/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.rpc.RpcCheckpointResponder;
import org.apache.flink.runtime.taskexecutor.rpc.RpcPartitionStateChecker;
import org.apache.flink.runtime.taskexecutor.rpc.RpcResultPartitionConsumableNotifier;

class ReusableTaskComponents {
    private final TaskExecutor.TaskManagerActionsImpl taskManagerActions;
    private final RpcCheckpointResponder checkpointResponder;
    private final BlobLibraryCacheManager libraryCacheManager;
    private final RpcResultPartitionConsumableNotifier resultPartitionConsumableNotifier;
    private final RpcPartitionStateChecker partitionStateChecker;

    ReusableTaskComponents(@Nonnull TaskExecutor.TaskManagerActionsImpl taskManagerActions, @Nonnull RpcCheckpointResponder checkpointResponder, @Nonnull BlobLibraryCacheManager libraryCacheManager, @Nonnull RpcResultPartitionConsumableNotifier resultPartitionConsumableNotifier, @Nonnull RpcPartitionStateChecker partitionStateChecker) {
        this.taskManagerActions = taskManagerActions;
        this.checkpointResponder = checkpointResponder;
        this.libraryCacheManager = libraryCacheManager;
        this.resultPartitionConsumableNotifier = resultPartitionConsumableNotifier;
        this.partitionStateChecker = partitionStateChecker;
    }

    TaskExecutor.TaskManagerActionsImpl getTaskManagerActions() {
        return this.taskManagerActions;
    }

    RpcCheckpointResponder getCheckpointResponder() {
        return this.checkpointResponder;
    }

    BlobLibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    RpcResultPartitionConsumableNotifier getResultPartitionConsumableNotifier() {
        return this.resultPartitionConsumableNotifier;
    }

    RpcPartitionStateChecker getPartitionStateChecker() {
        return this.partitionStateChecker;
    }

    void updateJobMasterGateway(JobMasterGateway jobMasterGateway) {
        this.taskManagerActions.notifyJobMasterGatewayChanged(jobMasterGateway);
        this.checkpointResponder.notifyCheckpointCoordinatorGatewayChanged(jobMasterGateway);
        this.resultPartitionConsumableNotifier.notifyJobMasterGatewayChanged(jobMasterGateway);
        this.partitionStateChecker.notifyJobMasterGatewayChanged(jobMasterGateway);
    }
}

