/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.rpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProviderException;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class RpcInputSplitProvider
implements InputSplitProvider {
    private final JobMasterGateway jobMasterGateway;
    private final JobVertexID jobVertexID;
    private final ExecutionAttemptID executionAttemptID;
    private final Time timeout;
    private final Map<OperatorID, List<InputSplit>> assignedInutSplits;

    public RpcInputSplitProvider(JobMasterGateway jobMasterGateway, JobVertexID jobVertexID, ExecutionAttemptID executionAttemptID, Time timeout) {
        this.jobMasterGateway = (JobMasterGateway)Preconditions.checkNotNull((Object)jobMasterGateway);
        this.jobVertexID = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexID)));
        this.executionAttemptID = (ExecutionAttemptID)((Object)Preconditions.checkNotNull((Object)((Object)executionAttemptID)));
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.assignedInutSplits = new HashMap<OperatorID, List<InputSplit>>(1);
    }

    @Override
    public InputSplit getNextInputSplit(OperatorID operatorID, ClassLoader userCodeClassLoader) throws InputSplitProviderException {
        Preconditions.checkNotNull((Object)((Object)operatorID));
        Preconditions.checkNotNull((Object)userCodeClassLoader);
        CompletableFuture<SerializedInputSplit> futureInputSplit = this.jobMasterGateway.requestNextInputSplit(this.jobVertexID, operatorID, this.executionAttemptID);
        try {
            SerializedInputSplit serializedInputSplit = futureInputSplit.get(this.timeout.getSize(), this.timeout.getUnit());
            if (serializedInputSplit.isEmpty()) {
                return null;
            }
            InputSplit inputSplit = (InputSplit)InstantiationUtil.deserializeObject((byte[])serializedInputSplit.getInputSplitData(), (ClassLoader)userCodeClassLoader);
            this.assignedInutSplits.putIfAbsent(operatorID, new ArrayList(1));
            this.assignedInutSplits.get((Object)operatorID).add(inputSplit);
            return inputSplit;
        }
        catch (Exception e) {
            throw new InputSplitProviderException("Requesting the next input split failed.", e);
        }
    }

    @Override
    public Map<OperatorID, List<InputSplit>> getAssignedInputSplits() {
        return this.assignedInutSplits;
    }
}

