/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.util.Preconditions;

public class SlotOffer
implements Serializable {
    private static final long serialVersionUID = -7067814231108250971L;
    private AllocationID allocationId;
    private final int slotIndex;
    private final ResourceProfile resourceProfile;
    private final List<SlotTag> tags;

    public SlotOffer(AllocationID allocationID, int index, ResourceProfile resourceProfile) {
        this(allocationID, index, resourceProfile, Collections.emptyList());
    }

    public SlotOffer(AllocationID allocationID, int index, ResourceProfile resourceProfile, List<SlotTag> tags) {
        Preconditions.checkArgument((0 <= index ? 1 : 0) != 0, (Object)"The index must be greater than 0.");
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)allocationID)));
        this.slotIndex = index;
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.tags = (List)Preconditions.checkNotNull(tags);
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public List<SlotTag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotOffer slotOffer = (SlotOffer)o;
        return this.allocationId.equals((Object)slotOffer.allocationId);
    }

    public int hashCode() {
        return this.allocationId.hashCode();
    }
}

