/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import javax.annotation.Nullable;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.netty.NettyConfig;

public class NetworkEnvironmentConfiguration {
    private final float networkBufFraction;
    private final long networkBufMin;
    private final long networkBufMax;
    private final int networkBufferSize;
    private final IOManager.IOMode ioMode;
    private final int partitionRequestInitialBackoff;
    private final int partitionRequestMaxBackoff;
    private final int networkBuffersPerChannel;
    private final int floatingNetworkBuffersPerGate;
    private final int networkBuffersPerExternalBlockingChannel;
    private final int floatingNetworkBuffersPerExternalBlockingGate;
    private final int networkBuffersPerSubpartition;
    private final NettyConfig nettyConfig;

    public NetworkEnvironmentConfiguration(float networkBufFraction, long networkBufMin, long networkBufMax, int networkBufferSize, IOManager.IOMode ioMode, int partitionRequestInitialBackoff, int partitionRequestMaxBackoff, int networkBuffersPerChannel, int floatingNetworkBuffersPerGate, int networkBuffersPerExternalBlockingChannel, int floatingNetworkBuffersPerExternalBlockingGate, int networkBuffersPerSubpartition) {
        this(networkBufFraction, networkBufMin, networkBufMax, networkBufferSize, ioMode, partitionRequestInitialBackoff, partitionRequestMaxBackoff, networkBuffersPerChannel, floatingNetworkBuffersPerGate, networkBuffersPerExternalBlockingChannel, floatingNetworkBuffersPerExternalBlockingGate, networkBuffersPerSubpartition, null);
    }

    public NetworkEnvironmentConfiguration(float networkBufFraction, long networkBufMin, long networkBufMax, int networkBufferSize, IOManager.IOMode ioMode, int partitionRequestInitialBackoff, int partitionRequestMaxBackoff, int networkBuffersPerChannel, int floatingNetworkBuffersPerGate, int networkBuffersPerExternalBlockingChannel, int floatingNetworkBuffersPerExternalBlockingGate, int networkBuffersPerSubpartition, @Nullable NettyConfig nettyConfig) {
        this.networkBufFraction = networkBufFraction;
        this.networkBufMin = networkBufMin;
        this.networkBufMax = networkBufMax;
        this.networkBufferSize = networkBufferSize;
        this.ioMode = ioMode;
        this.partitionRequestInitialBackoff = partitionRequestInitialBackoff;
        this.partitionRequestMaxBackoff = partitionRequestMaxBackoff;
        this.networkBuffersPerChannel = networkBuffersPerChannel;
        this.floatingNetworkBuffersPerGate = floatingNetworkBuffersPerGate;
        this.networkBuffersPerExternalBlockingChannel = networkBuffersPerExternalBlockingChannel;
        this.floatingNetworkBuffersPerExternalBlockingGate = floatingNetworkBuffersPerExternalBlockingGate;
        this.networkBuffersPerSubpartition = networkBuffersPerSubpartition;
        this.nettyConfig = nettyConfig;
    }

    public float networkBufFraction() {
        return this.networkBufFraction;
    }

    public long networkBufMin() {
        return this.networkBufMin;
    }

    public long networkBufMax() {
        return this.networkBufMax;
    }

    public int networkBufferSize() {
        return this.networkBufferSize;
    }

    public IOManager.IOMode ioMode() {
        return this.ioMode;
    }

    public int partitionRequestInitialBackoff() {
        return this.partitionRequestInitialBackoff;
    }

    public int partitionRequestMaxBackoff() {
        return this.partitionRequestMaxBackoff;
    }

    public int networkBuffersPerChannel() {
        return this.networkBuffersPerChannel;
    }

    public int floatingNetworkBuffersPerGate() {
        return this.floatingNetworkBuffersPerGate;
    }

    public int networkBuffersPerExternalBlockingChannel() {
        return this.networkBuffersPerExternalBlockingChannel;
    }

    public int floatingNetworkBuffersPerExternalBlockingGate() {
        return this.floatingNetworkBuffersPerExternalBlockingGate;
    }

    public int networkBuffersPerSubpartition() {
        return this.networkBuffersPerSubpartition;
    }

    public NettyConfig nettyConfig() {
        return this.nettyConfig;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.networkBufferSize;
        result = 31 * result + this.ioMode.hashCode();
        result = 31 * result + this.partitionRequestInitialBackoff;
        result = 31 * result + this.partitionRequestMaxBackoff;
        result = 31 * result + this.networkBuffersPerChannel;
        result = 31 * result + this.floatingNetworkBuffersPerGate;
        result = 31 * result + this.networkBuffersPerExternalBlockingChannel;
        result = 31 * result + this.floatingNetworkBuffersPerExternalBlockingGate;
        result = 31 * result + this.networkBuffersPerSubpartition;
        result = 31 * result + (this.nettyConfig != null ? this.nettyConfig.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkEnvironmentConfiguration that = (NetworkEnvironmentConfiguration)obj;
        return this.networkBufFraction == that.networkBufFraction && this.networkBufMin == that.networkBufMin && this.networkBufMax == that.networkBufMax && this.networkBufferSize == that.networkBufferSize && this.partitionRequestInitialBackoff == that.partitionRequestInitialBackoff && this.partitionRequestMaxBackoff == that.partitionRequestMaxBackoff && this.networkBuffersPerChannel == that.networkBuffersPerChannel && this.floatingNetworkBuffersPerGate == that.floatingNetworkBuffersPerGate && this.networkBuffersPerExternalBlockingChannel == that.networkBuffersPerExternalBlockingChannel && this.floatingNetworkBuffersPerExternalBlockingGate == that.floatingNetworkBuffersPerExternalBlockingGate && this.networkBuffersPerSubpartition == that.networkBuffersPerSubpartition && this.ioMode == that.ioMode && (this.nettyConfig != null ? this.nettyConfig.equals(that.nettyConfig) : that.nettyConfig == null);
    }

    public String toString() {
        return "NetworkEnvironmentConfiguration{networkBufFraction=" + this.networkBufFraction + ", networkBufMin=" + this.networkBufMin + ", networkBufMax=" + this.networkBufMax + ", networkBufferSize=" + this.networkBufferSize + ", ioMode=" + (Object)((Object)this.ioMode) + ", partitionRequestInitialBackoff=" + this.partitionRequestInitialBackoff + ", partitionRequestMaxBackoff=" + this.partitionRequestMaxBackoff + ", networkBuffersPerChannel=" + this.networkBuffersPerChannel + ", floatingNetworkBuffersPerGate=" + this.floatingNetworkBuffersPerGate + ", networkBuffersPerExternalBlockingChannel=" + this.networkBuffersPerExternalBlockingChannel + ", floatingNetworkBuffersPerExternalBlockingGate=" + this.floatingNetworkBuffersPerExternalBlockingGate + ", networkBuffersPerSubpartition=" + this.networkBuffersPerSubpartition + ", nettyConfig=" + this.nettyConfig + '}';
    }
}

