/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProviderException;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class TaskInputSplitProvider
implements InputSplitProvider {
    private final ActorGateway jobManager;
    private final JobID jobID;
    private final JobVertexID vertexID;
    private final ExecutionAttemptID executionID;
    private final FiniteDuration timeout;

    public TaskInputSplitProvider(ActorGateway jobManager, JobID jobID, JobVertexID vertexID, ExecutionAttemptID executionID, FiniteDuration timeout) {
        this.jobManager = (ActorGateway)Preconditions.checkNotNull((Object)jobManager);
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.vertexID = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)vertexID)));
        this.executionID = (ExecutionAttemptID)((Object)Preconditions.checkNotNull((Object)((Object)executionID)));
        this.timeout = (FiniteDuration)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public InputSplit getNextInputSplit(OperatorID operatorID, ClassLoader userCodeClassLoader) throws InputSplitProviderException {
        Object result;
        Preconditions.checkNotNull((Object)((Object)operatorID));
        Preconditions.checkNotNull((Object)userCodeClassLoader);
        Future<Object> response = this.jobManager.ask(new JobManagerMessages.RequestNextInputSplit(this.jobID, this.vertexID, operatorID, this.executionID), this.timeout);
        try {
            result = Await.result(response, (Duration)this.timeout);
        }
        catch (Exception e) {
            throw new InputSplitProviderException("Did not receive next input split from JobManager.", e);
        }
        if (result instanceof JobManagerMessages.NextInputSplit) {
            Object deserialized;
            JobManagerMessages.NextInputSplit nextInputSplit = (JobManagerMessages.NextInputSplit)result;
            byte[] serializedData = nextInputSplit.splitData();
            if (serializedData == null) {
                return null;
            }
            try {
                deserialized = InstantiationUtil.deserializeObject((byte[])serializedData, (ClassLoader)userCodeClassLoader);
            }
            catch (Exception e) {
                throw new InputSplitProviderException("Could not deserialize the serialized input split.", e);
            }
            return (InputSplit)deserialized;
        }
        throw new InputSplitProviderException("RequestNextInputSplit requires a response of type NextInputSplit. Instead response is of type " + result.getClass() + '.');
    }

    @Override
    public Map<OperatorID, List<InputSplit>> getAssignedInputSplits() {
        return null;
    }
}

