/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Comparator;
import java.util.TreeSet;
import org.apache.flink.util.Preconditions;

public class FixedSortedSet<E>
extends TreeSet<E> {
    private final int maxSize;
    private final Comparator<? super E> comparator;

    public FixedSortedSet(int maxSize) {
        this(maxSize, null);
    }

    public FixedSortedSet(int maxSize, Comparator<? super E> comparator) {
        super(comparator);
        this.maxSize = maxSize;
        this.comparator = comparator;
    }

    @Override
    public boolean add(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        if (this.maxSize <= 0) {
            return false;
        }
        if (this.size() >= this.maxSize) {
            Object last = this.last();
            if (last != null) {
                boolean canPut = false;
                if (this.comparator != null) {
                    if (this.comparator.compare(last, e) > 0) {
                        canPut = true;
                    }
                } else {
                    Preconditions.checkState((boolean)(e instanceof Comparable), (Object)"Element should be comparable if there is no comparator provided.");
                    Comparable comparable = (Comparable)last;
                    if (comparable.compareTo(e) > 0) {
                        canPut = true;
                    }
                }
                if (canPut) {
                    this.pollLast();
                    return super.add(e);
                }
            }
            return false;
        }
        return super.add(e);
    }
}

