/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.functions.sql

import org.apache.flink.table.calcite.FlinkTypeFactory

import org.apache.calcite.rel.`type`.RelDataType
import org.apache.calcite.sql.`type`.{ArraySqlType, OperandTypes, SqlReturnTypeInference, SqlTypeFamily, SqlTypeName}
import org.apache.calcite.sql.{SqlAggFunction, SqlFunctionCategory, SqlKind, SqlOperatorBinding}

class SqlApproximatePercentileAggFunction
  extends SqlAggFunction(
    "APPROX_PERCENTILE",
    null,
    SqlKind.OTHER_FUNCTION,
    new SqlReturnTypeInference {
      override def inferReturnType(opBinding: SqlOperatorBinding): RelDataType = {
        val factory = opBinding.getTypeFactory.asInstanceOf[FlinkTypeFactory]
        val doubleType = factory.createSqlType(SqlTypeName.DOUBLE)
        if (opBinding.getOperandType(1).isInstanceOf[ArraySqlType]) {
          factory.createArrayType(doubleType, -1)
        } else {
          doubleType
        }
      }
    },
    null,
    OperandTypes.or(
      OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC),
      OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC)),
    SqlFunctionCategory.NUMERIC,
    false,
    false) {
  // override nothing.
}
