/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.sources.parquet.update;

import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.ColumnarRow;

/**
 * Column Row to read updated parquet data and append INPUT_FILE_NAME, for delete dml source.
 *
 */
public class VirtualColumnarRow extends ColumnarRow {

	// input file name.
	private BinaryString fileName;

	public void setFileName(String fileName) {
		this.fileName = BinaryString.fromString(fileName);
	}

	@Override
	public int getArity() {
		return vectorizedColumnBatch.getArity() + 1;
	}

	@Override
	public boolean isNullAt(int ordinal) {
		if (ordinal == vectorizedColumnBatch.getArity()) {
			return false;
		} else {
			return super.isNullAt(ordinal);
		}
	}

	@Override
	public BinaryString getBinaryString(int ordinal) {
		if (ordinal == vectorizedColumnBatch.getArity()) {
			return fileName;
		} else {
			return super.getBinaryString(ordinal);
		}
	}

	@Override
	public BinaryString getBinaryString(int ordinal, BinaryString reuse) {
		if (ordinal == vectorizedColumnBatch.getArity()) {
			return fileName;
		} else {
			return super.getBinaryString(ordinal, reuse);
		}
	}
}
