/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read;

import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.read.BaseSaxAnalyser;
import com.alibaba.excel.read.context.AnalysisContext;
import com.alibaba.excel.read.exception.ExcelAnalysisException;
import com.alibaba.excel.read.v07.RowHandler;
import com.alibaba.excel.read.v07.XMLTempFile;
import com.alibaba.excel.read.v07.XmlParserFactory;
import com.alibaba.excel.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorkbookDocument;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxAnalyserV07
extends BaseSaxAnalyser {
    private SharedStringsTable sharedStringsTable;
    private List<String> sharedStringList = new LinkedList<String>();
    private List<SheetSource> sheetSourceList = new ArrayList<SheetSource>();
    private boolean use1904WindowDate = false;
    private final String path;
    private File tmpFile;
    private String workBookXMLFilePath;
    private String sharedStringXMLFilePath;

    public SaxAnalyserV07(AnalysisContext analysisContext) throws Exception {
        this.analysisContext = analysisContext;
        this.path = XMLTempFile.createPath();
        this.tmpFile = new File(XMLTempFile.getTmpFilePath(this.path));
        this.workBookXMLFilePath = XMLTempFile.getWorkBookFilePath(this.path);
        this.sharedStringXMLFilePath = XMLTempFile.getSharedStringFilePath(this.path);
        this.start();
    }

    @Override
    protected void execute() {
        try {
            Sheet sheet = this.analysisContext.getCurrentSheet();
            if (!this.isAnalysisAllSheets(sheet)) {
                if (this.sheetSourceList.size() < sheet.getSheetNo() || sheet.getSheetNo() == 0) {
                    return;
                }
                InputStream sheetInputStream = this.sheetSourceList.get(sheet.getSheetNo() - 1).getInputStream();
                this.parseXmlSource(sheetInputStream);
                return;
            }
            int i = 0;
            for (SheetSource sheetSource : this.sheetSourceList) {
                this.analysisContext.setCurrentSheet(new Sheet(++i));
                this.parseXmlSource(sheetSource.getInputStream());
            }
        }
        catch (Exception e) {
            this.stop();
            throw new ExcelAnalysisException(e);
        }
    }

    private boolean isAnalysisAllSheets(Sheet sheet) {
        if (sheet == null) {
            return true;
        }
        return sheet.getSheetNo() < 0;
    }

    @Override
    public void stop() {
        for (SheetSource sheet : this.sheetSourceList) {
            if (sheet.getInputStream() == null) continue;
            try {
                sheet.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileUtil.deletefile(this.path);
    }

    private void parseXmlSource(InputStream inputStream) {
        try {
            RowHandler handler = new RowHandler(this, this.sharedStringsTable, this.analysisContext, this.sharedStringList);
            XmlParserFactory.parse(inputStream, handler);
            inputStream.close();
        }
        catch (Exception e) {
            try {
                inputStream.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new ExcelAnalysisException(e);
        }
    }

    @Override
    public List<Sheet> getSheets() {
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        try {
            int i = 1;
            for (SheetSource sheetSource : this.sheetSourceList) {
                Sheet sheet = new Sheet(i, 0);
                sheet.setSheetName(sheetSource.getSheetName());
                ++i;
                sheets.add(sheet);
            }
        }
        catch (Exception e) {
            this.stop();
            throw new ExcelAnalysisException(e);
        }
        return sheets;
    }

    private void start() throws IOException, XmlException, ParserConfigurationException, SAXException {
        this.createTmpFile();
        this.unZipTempFile();
        this.initSharedStringsTable();
        this.initUse1904WindowDate();
        this.initSheetSourceList();
    }

    private void createTmpFile() throws FileNotFoundException {
        FileUtil.writeFile(this.tmpFile, this.analysisContext.getInputStream());
    }

    private void unZipTempFile() throws IOException {
        FileUtil.doUnZip(this.path, this.tmpFile);
    }

    private void initSheetSourceList() throws IOException, ParserConfigurationException, SAXException {
        this.sheetSourceList = new ArrayList<SheetSource>();
        FileInputStream workbookXml = new FileInputStream(this.workBookXMLFilePath);
        XmlParserFactory.parse(workbookXml, new DefaultHandler(){
            private int id = 0;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
                if (qName.toLowerCase(Locale.US).equals("sheet")) {
                    String name = null;
                    ++this.id;
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        if (attrs.getLocalName(i).toLowerCase(Locale.US).equals("name")) {
                            name = attrs.getValue(i);
                            continue;
                        }
                        if (!attrs.getLocalName(i).toLowerCase(Locale.US).equals("r:id")) continue;
                        try {
                            FileInputStream inputStream = new FileInputStream(XMLTempFile.getSheetFilePath(SaxAnalyserV07.this.path, this.id));
                            SaxAnalyserV07.this.sheetSourceList.add(new SheetSource(this.id, name, inputStream));
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        ((InputStream)workbookXml).close();
        Collections.sort(this.sheetSourceList);
    }

    private void initUse1904WindowDate() throws IOException, XmlException {
        FileInputStream workbookXml = new FileInputStream(this.workBookXMLFilePath);
        WorkbookDocument ctWorkbook = WorkbookDocument.Factory.parse((InputStream)workbookXml);
        CTWorkbook wb = ctWorkbook.getWorkbook();
        CTWorkbookPr prefix = wb.getWorkbookPr();
        if (prefix != null) {
            this.use1904WindowDate = prefix.getDate1904();
        }
        this.analysisContext.setUse1904WindowDate(this.use1904WindowDate);
        ((InputStream)workbookXml).close();
    }

    private void initSharedStringsTable() throws IOException, ParserConfigurationException, SAXException {
        FileInputStream inputStream = new FileInputStream(this.sharedStringXMLFilePath);
        XmlParserFactory.parse(inputStream, new DefaultHandler(){
            String beforeQName = "";
            String currentQName = "";

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if ("si".equals(qName) || "t".equals(qName)) {
                    this.beforeQName = this.currentQName;
                    this.currentQName = qName;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if ("t".equals(this.currentQName) && "t".equals(this.beforeQName)) {
                    String pre = (String)SaxAnalyserV07.this.sharedStringList.get(SaxAnalyserV07.this.sharedStringList.size() - 1);
                    String str = pre + new String(ch, start, length);
                    SaxAnalyserV07.this.sharedStringList.remove(SaxAnalyserV07.this.sharedStringList.size() - 1);
                    SaxAnalyserV07.this.sharedStringList.add(str);
                } else if ("t".equals(this.currentQName) && "si".equals(this.beforeQName)) {
                    SaxAnalyserV07.this.sharedStringList.add(new String(ch, start, length));
                }
            }
        });
        ((InputStream)inputStream).close();
    }

    private class SheetSource
    implements Comparable<SheetSource> {
        private int id;
        private String sheetName;
        private InputStream inputStream;

        public SheetSource(int id, String sheetName, InputStream inputStream) {
            this.id = id;
            this.sheetName = sheetName;
            this.inputStream = inputStream;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Override
        public int compareTo(SheetSource o) {
            if (o.id == this.id) {
                return 0;
            }
            if (o.id > this.id) {
                return -1;
            }
            return 1;
        }
    }
}

