/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write;

import com.alibaba.excel.metadata.ExcelColumnProperty;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.metadata.Table;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.EasyExcelTempFile;
import com.alibaba.excel.write.ExcelBuilder;
import com.alibaba.excel.write.context.GenerateContext;
import com.alibaba.excel.write.context.GenerateContextImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelBuilderImpl
implements ExcelBuilder {
    private GenerateContext context;

    @Override
    public void init(OutputStream out, ExcelTypeEnum excelType, boolean needHead) {
        EasyExcelTempFile.createPOIFilesDirectory();
        this.context = new GenerateContextImpl(out, excelType, needHead);
    }

    @Override
    public void addContent(List data) {
        if (data != null && data.size() > 0) {
            Row row;
            int rowNum = this.context.getCurrentSheet().getLastRowNum();
            if (!(rowNum != 0 || (row = this.context.getCurrentSheet().getRow(0)) != null || this.context.getExcelHeadProperty() != null && this.context.needHead())) {
                rowNum = -1;
            }
            for (int i = 0; i < data.size(); ++i) {
                int n = i + rowNum + 1;
                this.addOneRowOfDataToExcel(data.get(i), n);
            }
        }
    }

    @Override
    public void addContent(List data, Sheet sheetParam) {
        this.context.buildCurrentSheet(sheetParam);
        this.addContent(data);
    }

    @Override
    public void addContent(List data, Sheet sheetParam, Table table) {
        this.context.buildCurrentSheet(sheetParam);
        this.context.buildTable(table);
        this.addContent(data);
    }

    @Override
    public void finish() {
        try {
            this.context.getWorkbook().write(this.context.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addOneRowOfDataToExcel(List<String> oneRowData, Row row) {
        if (oneRowData != null && oneRowData.size() > 0) {
            for (int i = 0; i < oneRowData.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(this.context.getCurrentContentStyle());
                cell.setCellValue(oneRowData.get(i));
            }
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, Row row) {
        int i = 0;
        for (ExcelColumnProperty excelHeadProperty : this.context.getExcelHeadProperty().getColumnPropertyList()) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.context.getCurrentContentStyle());
            String cellValue = null;
            try {
                cellValue = BeanUtils.getProperty((Object)oneRowData, (String)excelHeadProperty.getField().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (cellValue != null) {
                cell.setCellValue(cellValue);
            } else {
                cell.setCellValue("");
            }
            ++i;
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n) {
        Row row = this.context.getCurrentSheet().createRow(n);
        if (oneRowData instanceof List) {
            this.addOneRowOfDataToExcel((List)oneRowData, row);
        } else {
            this.addOneRowOfDataToExcel(oneRowData, row);
        }
    }
}

