/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.ddl;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLUnique;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.util.JdbcConstants;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DdlResult;
import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DruidDdlParser {
    public static List<DdlResult> parse(String queryString, String schmeaName) {
        List stmtList = null;
        try {
            stmtList = SQLUtils.parseStatements((String)queryString, (DbType)JdbcConstants.MYSQL, (boolean)false);
        }
        catch (ParserException e) {
            DdlResult ddlResult = new DdlResult();
            ddlResult.setType(CanalEntry.EventType.QUERY);
            return Arrays.asList(ddlResult);
        }
        ArrayList<DdlResult> ddlResults = new ArrayList<DdlResult>();
        for (SQLStatement statement : stmtList) {
            DdlResult ddlResult;
            DdlResult ddlResult2;
            Object tableSource;
            DdlResult ddlResult3;
            DdlResult ddlResult4;
            if (statement instanceof SQLCreateTableStatement) {
                ddlResult4 = new DdlResult();
                SQLCreateTableStatement createTable = (SQLCreateTableStatement)statement;
                DruidDdlParser.processName(ddlResult4, schmeaName, (SQLExpr)createTable.getName(), false);
                ddlResult4.setType(CanalEntry.EventType.CREATE);
                ddlResults.add(ddlResult4);
                continue;
            }
            if (statement instanceof SQLAlterTableStatement) {
                SQLAlterTableStatement alterTable = (SQLAlterTableStatement)statement;
                for (SQLAlterTableItem item : alterTable.getItems()) {
                    if (item instanceof SQLAlterTableRename) {
                        ddlResult3 = new DdlResult();
                        DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)alterTable.getName(), true);
                        DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)((SQLAlterTableRename)item).getToName(), false);
                        ddlResult3.setType(CanalEntry.EventType.RENAME);
                        ddlResults.add(ddlResult3);
                        continue;
                    }
                    if (item instanceof SQLAlterTableAddIndex) {
                        ddlResult3 = new DdlResult();
                        DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)alterTable.getName(), false);
                        ddlResult3.setType(CanalEntry.EventType.CINDEX);
                        ddlResults.add(ddlResult3);
                        continue;
                    }
                    if (item instanceof SQLAlterTableDropIndex || item instanceof SQLAlterTableDropKey) {
                        ddlResult3 = new DdlResult();
                        DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)alterTable.getName(), false);
                        ddlResult3.setType(CanalEntry.EventType.DINDEX);
                        ddlResults.add(ddlResult3);
                        continue;
                    }
                    if (item instanceof SQLAlterTableAddConstraint) {
                        ddlResult3 = new DdlResult();
                        DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)alterTable.getName(), false);
                        SQLConstraint constraint = ((SQLAlterTableAddConstraint)item).getConstraint();
                        if (!(constraint instanceof SQLUnique)) continue;
                        ddlResult3.setType(CanalEntry.EventType.CINDEX);
                        ddlResults.add(ddlResult3);
                        continue;
                    }
                    if (item instanceof SQLAlterTableDropConstraint) {
                        ddlResult3 = new DdlResult();
                        DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)alterTable.getName(), false);
                        ddlResult3.setType(CanalEntry.EventType.DINDEX);
                        ddlResults.add(ddlResult3);
                        continue;
                    }
                    ddlResult3 = new DdlResult();
                    DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)alterTable.getName(), false);
                    ddlResult3.setType(CanalEntry.EventType.ALTER);
                    ddlResults.add(ddlResult3);
                }
                continue;
            }
            if (statement instanceof SQLDropTableStatement) {
                SQLDropTableStatement dropTable = (SQLDropTableStatement)statement;
                for (SQLExprTableSource tableSource2 : dropTable.getTableSources()) {
                    ddlResult3 = new DdlResult();
                    DruidDdlParser.processName(ddlResult3, schmeaName, tableSource2.getExpr(), false);
                    ddlResult3.setType(CanalEntry.EventType.ERASE);
                    ddlResults.add(ddlResult3);
                }
                continue;
            }
            if (statement instanceof SQLCreateIndexStatement) {
                SQLCreateIndexStatement createIndex = (SQLCreateIndexStatement)statement;
                tableSource = createIndex.getTable();
                ddlResult2 = new DdlResult();
                DruidDdlParser.processName(ddlResult2, schmeaName, ((SQLExprTableSource)tableSource).getExpr(), false);
                ddlResult2.setType(CanalEntry.EventType.CINDEX);
                ddlResults.add(ddlResult2);
                continue;
            }
            if (statement instanceof SQLDropIndexStatement) {
                SQLDropIndexStatement dropIndex = (SQLDropIndexStatement)statement;
                tableSource = dropIndex.getTableName();
                ddlResult2 = new DdlResult();
                DruidDdlParser.processName(ddlResult2, schmeaName, tableSource.getExpr(), false);
                ddlResult2.setType(CanalEntry.EventType.DINDEX);
                ddlResults.add(ddlResult2);
                continue;
            }
            if (statement instanceof SQLTruncateStatement) {
                SQLTruncateStatement truncate = (SQLTruncateStatement)statement;
                for (SQLExprTableSource tableSource2 : truncate.getTableSources()) {
                    ddlResult3 = new DdlResult();
                    DruidDdlParser.processName(ddlResult3, schmeaName, tableSource2.getExpr(), false);
                    ddlResult3.setType(CanalEntry.EventType.TRUNCATE);
                    ddlResults.add(ddlResult3);
                }
                continue;
            }
            if (statement instanceof MySqlRenameTableStatement) {
                MySqlRenameTableStatement rename = (MySqlRenameTableStatement)statement;
                for (SQLAlterTableItem item : rename.getItems()) {
                    ddlResult3 = new DdlResult();
                    DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)item.getName(), true);
                    DruidDdlParser.processName(ddlResult3, schmeaName, (SQLExpr)item.getTo(), false);
                    ddlResult3.setType(CanalEntry.EventType.RENAME);
                    ddlResults.add(ddlResult3);
                }
                continue;
            }
            if (statement instanceof SQLInsertStatement) {
                ddlResult4 = new DdlResult();
                SQLInsertStatement insert = (SQLInsertStatement)statement;
                DruidDdlParser.processName(ddlResult4, schmeaName, (SQLExpr)insert.getTableName(), false);
                ddlResult4.setType(CanalEntry.EventType.INSERT);
                ddlResults.add(ddlResult4);
                continue;
            }
            if (statement instanceof SQLUpdateStatement) {
                ddlResult4 = new DdlResult();
                SQLUpdateStatement update = (SQLUpdateStatement)statement;
                DruidDdlParser.processName(ddlResult4, schmeaName, (SQLExpr)update.getTableName(), false);
                ddlResult4.setType(CanalEntry.EventType.UPDATE);
                ddlResults.add(ddlResult4);
                continue;
            }
            if (statement instanceof SQLDeleteStatement) {
                ddlResult4 = new DdlResult();
                SQLDeleteStatement delete = (SQLDeleteStatement)statement;
                DruidDdlParser.processName(ddlResult4, schmeaName, (SQLExpr)delete.getTableName(), false);
                ddlResult4.setType(CanalEntry.EventType.DELETE);
                ddlResults.add(ddlResult4);
                continue;
            }
            if (statement instanceof SQLCreateDatabaseStatement) {
                SQLCreateDatabaseStatement create = (SQLCreateDatabaseStatement)statement;
                ddlResult = new DdlResult();
                ddlResult.setType(CanalEntry.EventType.QUERY);
                DruidDdlParser.processName(ddlResult, create.getDatabaseName(), null, false);
                ddlResults.add(ddlResult);
                continue;
            }
            if (!(statement instanceof SQLDropDatabaseStatement)) continue;
            SQLDropDatabaseStatement drop = (SQLDropDatabaseStatement)statement;
            ddlResult = new DdlResult();
            ddlResult.setType(CanalEntry.EventType.QUERY);
            DruidDdlParser.processName(ddlResult, drop.getDatabaseName(), null, false);
            ddlResults.add(ddlResult);
        }
        return ddlResults;
    }

    private static void processName(DdlResult ddlResult, String schema, SQLExpr sqlName, boolean isOri) {
        if (sqlName == null) {
            if (StringUtils.isNotBlank((String)schema)) {
                ddlResult.setSchemaName(schema);
            }
            return;
        }
        String table = null;
        if (sqlName instanceof SQLPropertyExpr) {
            SQLIdentifierExpr owner = (SQLIdentifierExpr)((SQLPropertyExpr)sqlName).getOwner();
            schema = DruidDdlParser.unescapeName(owner.getName());
            table = DruidDdlParser.unescapeName(((SQLPropertyExpr)sqlName).getName());
        } else if (sqlName instanceof SQLIdentifierExpr) {
            table = DruidDdlParser.unescapeName(((SQLIdentifierExpr)sqlName).getName());
        }
        if (isOri) {
            ddlResult.setOriSchemaName(schema);
            ddlResult.setOriTableName(table);
        } else {
            ddlResult.setSchemaName(schema);
            ddlResult.setTableName(table);
        }
    }

    public static String unescapeName(String name) {
        if (name != null && name.length() > 2) {
            char c0 = name.charAt(0);
            char x0 = name.charAt(name.length() - 1);
            if (c0 == '\"' && x0 == '\"' || c0 == '`' && x0 == '`') {
                return name.substring(1, name.length() - 1);
            }
        }
        return name;
    }

    public static String unescapeQuotaName(String name) {
        if (name != null && name.length() > 2) {
            char c0 = name.charAt(0);
            char x0 = name.charAt(name.length() - 1);
            if (c0 == '\'' && x0 == '\'') {
                return name.substring(1, name.length() - 1);
            }
        }
        return name;
    }
}

