/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.internal.javassist.CannotCompileException;
import com.alibaba.ttl.internal.javassist.CtClass;
import com.alibaba.ttl.internal.javassist.CtField;
import com.alibaba.ttl.internal.javassist.CtMethod;
import com.alibaba.ttl.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import java.io.IOException;

public class TtlTimerTaskTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlTimerTaskTransformlet.class);
    private static final String TIMER_TASK_CLASS_NAME = "java.util.TimerTask";
    private static final String RUN_METHOD_NAME = "run";

    @Override
    public byte[] doTransform(String className, byte[] classFileBuffer, ClassLoader loader) throws IOException, NotFoundException, CannotCompileException {
        if (TIMER_TASK_CLASS_NAME.equals(className)) {
            return null;
        }
        CtClass clazz = Utils.getCtClass(classFileBuffer, loader);
        if (clazz.isPrimitive() || clazz.isArray() || clazz.isInterface() || clazz.isAnnotation()) {
            return null;
        }
        try {
            CtMethod runMethod = clazz.getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
            if (!CtClass.voidType.equals(runMethod.getReturnType())) {
                return null;
            }
        }
        catch (NotFoundException e) {
            return null;
        }
        if (!clazz.subclassOf(clazz.getClassPool().get(TIMER_TASK_CLASS_NAME))) {
            return null;
        }
        logger.info("Transforming class " + className);
        this.updateTimerTaskClass(clazz);
        return clazz.toBytecode();
    }

    private void updateTimerTaskClass(CtClass clazz) throws CannotCompileException, NotFoundException {
        String className = clazz.getName();
        String capturedFieldName = "captured$field$added$by$ttl";
        CtField capturedField = CtField.make("private final Object captured$field$added$by$ttl;", clazz);
        clazz.addField(capturedField, "com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils.doCaptureWhenNotTtlEnhanced(this);");
        logger.info("add new field captured$field$added$by$ttl to class " + className);
        CtMethod runMethod = clazz.getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
        String beforeCode = "Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$added$by$ttl);";
        String finallyCode = "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);";
        Utils.doTryFinallyForMethod(runMethod, "Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$added$by$ttl);", "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);");
    }
}

