/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.bootstrap;

import com.alipay.sofa.registry.server.session.bootstrap.CommonConfig;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="session.server")
public class SessionServerConfigBean
implements SessionServerConfig {
    public static final String PREFIX = "session.server";
    private int serverPort = 9600;
    private int metaServerPort = 9610;
    private int dataServerPort = 9620;
    private int httpServerPort;
    private int schedulerHeartbeatTimeout = 3;
    private int schedulerHeartbeatFirstDelay = 3;
    private int schedulerHeartbeatExpBackOffBound = 10;
    private int schedulerGetSessionNodeTimeout = 3;
    private int schedulerGetSessionNodeFirstDelay = 5;
    private int schedulerGetSessionNodeExpBackOffBound = 10;
    private int schedulerFetchDataTimeout = 1;
    private int schedulerFetchDataFirstDelay = 30;
    private int schedulerFetchDataExpBackOffBound = 10;
    private int schedulerConnectMetaTimeout = 5;
    private int schedulerConnectMetaFirstDelay = 5;
    private int schedulerConnectMetaExpBackOffBound = 10;
    private int schedulerConnectDataTimeout = 3;
    private int schedulerConnectDataFirstDelay = 3;
    private int schedulerConnectDataExpBackOffBound = 10;
    private int cancelDataTaskRetryTimes = 5;
    private int cancelDataTaskRetryFirstDelay = 100;
    private long cancelDataTaskRetryIncrementDelay = 200L;
    private int dataChangeFetchTaskRetryTimes = 3;
    private int subscriberRegisterFetchRetryTimes = 3;
    private int receivedDataMultiPushTaskRetryTimes = 3;
    private int sessionRegisterDataServerTaskRetryTimes = 5;
    private int defaultSessionExecutorMinPoolSize = SessionServerConfigBean.cpus();
    private int defaultSessionExecutorMaxPoolSize = SessionServerConfigBean.cpus() * 5;
    private long defaultSessionExecutorKeepAliveTime = 60L;
    private int accessDataExecutorMinPoolSize = 100;
    private int accessDataExecutorMaxPoolSize = 400;
    private int accessDataExecutorQueueSize = 10000;
    private long accessDataExecutorKeepAliveTime = 60L;
    private int pushTaskExecutorMinPoolSize = 40;
    private int pushTaskExecutorMaxPoolSize = 400;
    private int pushTaskExecutorQueueSize = 100000;
    private long pushTaskExecutorKeepAliveTime = 60L;
    private int dataChangeExecutorMinPoolSize = 40;
    private int dataChangeExecutorMaxPoolSize = 400;
    private int dataChangeExecutorQueueSize = 100000;
    private long dataChangeExecutorKeepAliveTime = 60L;
    private int disconnectClientExecutorMinPoolSize = 40;
    private int disconnectClientExecutorMaxPoolSize = 200;
    private int disconnectClientExecutorQueueSize = 10000;
    private int dataChangeFetchTaskMaxBufferSize = 1000000;
    private int dataChangeFetchTaskWorkerSize = 100;
    private int clientNodeExchangeTimeOut = 1000;
    private int dataNodeExchangeTimeOut = 3000;
    private int metaNodeExchangeTimeOut = 3000;
    private int numberOfReplicas = 1000;
    private int userDataPushRetryWheelTicksSize = 5120;
    private int userDataPushRetryWheelTicksDuration = 100;
    private int pushDataTaskRetryFirstDelay = 500;
    private long pushDataTaskRetryIncrementDelay = 500L;
    private String sessionServerRegion;
    private String sessionServerDataCenter;
    private boolean stopPushSwitch = false;
    private boolean beginDataFetchTask = false;
    private String invalidForeverZones = "";
    private String invalidIgnoreDataidRegex = "";
    private Set<String> invalidForeverZonesSet;
    private Pattern invalidIgnoreDataIdPattern = null;
    private String pushEmptyDataDataIdPrefixes = "";
    private Set<String> pushEmptyDataDataIdPrefixesSet;
    private CommonConfig commonConfig;

    public SessionServerConfigBean(CommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public int getSchedulerHeartbeatTimeout() {
        return this.schedulerHeartbeatTimeout;
    }

    public void setSchedulerHeartbeatTimeout(int schedulerHeartbeatTimeout) {
        this.schedulerHeartbeatTimeout = schedulerHeartbeatTimeout;
    }

    @Override
    public int getSchedulerHeartbeatFirstDelay() {
        return this.schedulerHeartbeatFirstDelay;
    }

    public void setSchedulerHeartbeatFirstDelay(int schedulerHeartbeatFirstDelay) {
        this.schedulerHeartbeatFirstDelay = schedulerHeartbeatFirstDelay;
    }

    @Override
    public int getSchedulerHeartbeatExpBackOffBound() {
        return this.schedulerHeartbeatExpBackOffBound;
    }

    public void setSchedulerHeartbeatExpBackOffBound(int schedulerHeartbeatExpBackOffBound) {
        this.schedulerHeartbeatExpBackOffBound = schedulerHeartbeatExpBackOffBound;
    }

    @Override
    public int getSchedulerFetchDataTimeout() {
        return this.schedulerFetchDataTimeout;
    }

    public void setSchedulerFetchDataTimeout(int schedulerFetchDataTimeout) {
        this.schedulerFetchDataTimeout = schedulerFetchDataTimeout;
    }

    @Override
    public int getSchedulerFetchDataFirstDelay() {
        return this.schedulerFetchDataFirstDelay;
    }

    public void setSchedulerFetchDataFirstDelay(int schedulerFetchDataFirstDelay) {
        this.schedulerFetchDataFirstDelay = schedulerFetchDataFirstDelay;
    }

    @Override
    public int getSchedulerFetchDataExpBackOffBound() {
        return this.schedulerFetchDataExpBackOffBound;
    }

    public void setSchedulerFetchDataExpBackOffBound(int schedulerFetchDataExpBackOffBound) {
        this.schedulerFetchDataExpBackOffBound = schedulerFetchDataExpBackOffBound;
    }

    @Override
    public int getCancelDataTaskRetryTimes() {
        return this.cancelDataTaskRetryTimes;
    }

    public void setCancelDataTaskRetryTimes(int cancelDataTaskRetryTimes) {
        this.cancelDataTaskRetryTimes = cancelDataTaskRetryTimes;
    }

    @Override
    public int getCancelDataTaskRetryFirstDelay() {
        return this.cancelDataTaskRetryFirstDelay;
    }

    public void setCancelDataTaskRetryFirstDelay(int cancelDataTaskRetryFirstDelay) {
        this.cancelDataTaskRetryFirstDelay = cancelDataTaskRetryFirstDelay;
    }

    @Override
    public long getCancelDataTaskRetryIncrementDelay() {
        return this.cancelDataTaskRetryIncrementDelay;
    }

    public void setCancelDataTaskRetryIncrementDelay(long cancelDataTaskRetryIncrementDelay) {
        this.cancelDataTaskRetryIncrementDelay = cancelDataTaskRetryIncrementDelay;
    }

    @Override
    public int getReceivedDataMultiPushTaskRetryTimes() {
        return this.receivedDataMultiPushTaskRetryTimes;
    }

    public void setReceivedDataMultiPushTaskRetryTimes(int receivedDataMultiPushTaskRetryTimes) {
        this.receivedDataMultiPushTaskRetryTimes = receivedDataMultiPushTaskRetryTimes;
    }

    @Override
    public int getDataChangeFetchTaskRetryTimes() {
        return this.dataChangeFetchTaskRetryTimes;
    }

    public void setDataChangeFetchTaskRetryTimes(int dataChangeFetchTaskRetryTimes) {
        this.dataChangeFetchTaskRetryTimes = dataChangeFetchTaskRetryTimes;
    }

    @Override
    public int getSubscriberRegisterFetchRetryTimes() {
        return this.subscriberRegisterFetchRetryTimes;
    }

    public void setSubscriberRegisterFetchRetryTimes(int subscriberRegisterFetchRetryTimes) {
        this.subscriberRegisterFetchRetryTimes = subscriberRegisterFetchRetryTimes;
    }

    @Override
    public int getSessionRegisterDataServerTaskRetryTimes() {
        return this.sessionRegisterDataServerTaskRetryTimes;
    }

    public void setSessionRegisterDataServerTaskRetryTimes(int sessionRegisterDataServerTaskRetryTimes) {
        this.sessionRegisterDataServerTaskRetryTimes = sessionRegisterDataServerTaskRetryTimes;
    }

    @Override
    public int getClientNodeExchangeTimeOut() {
        return this.clientNodeExchangeTimeOut;
    }

    public void setClientNodeExchangeTimeOut(int clientNodeExchangeTimeOut) {
        this.clientNodeExchangeTimeOut = clientNodeExchangeTimeOut;
    }

    @Override
    public int getDataNodeExchangeTimeOut() {
        return this.dataNodeExchangeTimeOut;
    }

    public void setDataNodeExchangeTimeOut(int dataNodeExchangeTimeOut) {
        this.dataNodeExchangeTimeOut = dataNodeExchangeTimeOut;
    }

    @Override
    public int getMetaServerPort() {
        return this.metaServerPort;
    }

    public void setMetaServerPort(int metaServerPort) {
        this.metaServerPort = metaServerPort;
    }

    @Override
    public String getSessionServerRegion() {
        String region;
        if (this.commonConfig != null && (region = this.commonConfig.getLocalRegion()) != null && !region.isEmpty()) {
            return this.commonConfig.getLocalRegion().toUpperCase();
        }
        if (this.sessionServerRegion != null) {
            this.sessionServerRegion = this.sessionServerRegion.toUpperCase();
        }
        return this.sessionServerRegion;
    }

    public void setSessionServerRegion(String sessionServerRegion) {
        if (sessionServerRegion != null) {
            sessionServerRegion = sessionServerRegion.toUpperCase();
        }
        this.sessionServerRegion = sessionServerRegion;
    }

    @Override
    public String getSessionServerDataCenter() {
        String dataCenter;
        if (this.commonConfig != null && (dataCenter = this.commonConfig.getLocalDataCenter()) != null && !dataCenter.isEmpty()) {
            return this.commonConfig.getLocalDataCenter();
        }
        return this.sessionServerDataCenter;
    }

    public void setSessionServerDataCenter(String sessionServerDataCenter) {
        this.sessionServerDataCenter = sessionServerDataCenter;
    }

    @Override
    public int getMetaNodeExchangeTimeOut() {
        return this.metaNodeExchangeTimeOut;
    }

    public void setMetaNodeExchangeTimeOut(int metaNodeExchangeTimeOut) {
        this.metaNodeExchangeTimeOut = metaNodeExchangeTimeOut;
    }

    @Override
    public int getDataServerPort() {
        return this.dataServerPort;
    }

    public void setDataServerPort(int dataServerPort) {
        this.dataServerPort = dataServerPort;
    }

    @Override
    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    @Override
    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public void setNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    @Override
    public int getSchedulerGetSessionNodeTimeout() {
        return this.schedulerGetSessionNodeTimeout;
    }

    public void setSchedulerGetSessionNodeTimeout(int schedulerGetSessionNodeTimeout) {
        this.schedulerGetSessionNodeTimeout = schedulerGetSessionNodeTimeout;
    }

    @Override
    public int getSchedulerGetSessionNodeFirstDelay() {
        return this.schedulerGetSessionNodeFirstDelay;
    }

    public void setSchedulerGetSessionNodeFirstDelay(int schedulerGetSessionNodeFirstDelay) {
        this.schedulerGetSessionNodeFirstDelay = schedulerGetSessionNodeFirstDelay;
    }

    @Override
    public int getSchedulerGetSessionNodeExpBackOffBound() {
        return this.schedulerGetSessionNodeExpBackOffBound;
    }

    public void setSchedulerGetSessionNodeExpBackOffBound(int schedulerGetSessionNodeExpBackOffBound) {
        this.schedulerGetSessionNodeExpBackOffBound = schedulerGetSessionNodeExpBackOffBound;
    }

    @Override
    public int getSchedulerConnectMetaTimeout() {
        return this.schedulerConnectMetaTimeout;
    }

    @Override
    public int getSchedulerConnectMetaFirstDelay() {
        return this.schedulerConnectMetaFirstDelay;
    }

    @Override
    public int getSchedulerConnectMetaExpBackOffBound() {
        return this.schedulerConnectMetaExpBackOffBound;
    }

    public void setSchedulerConnectMetaTimeout(int schedulerConnectMetaTimeout) {
        this.schedulerConnectMetaTimeout = schedulerConnectMetaTimeout;
    }

    public void setSchedulerConnectMetaFirstDelay(int schedulerConnectMetaFirstDelay) {
        this.schedulerConnectMetaFirstDelay = schedulerConnectMetaFirstDelay;
    }

    public void setSchedulerConnectMetaExpBackOffBound(int schedulerConnectMetaExpBackOffBound) {
        this.schedulerConnectMetaExpBackOffBound = schedulerConnectMetaExpBackOffBound;
    }

    @Override
    public int getSchedulerConnectDataTimeout() {
        return this.schedulerConnectDataTimeout;
    }

    public void setSchedulerConnectDataTimeout(int schedulerConnectDataTimeout) {
        this.schedulerConnectDataTimeout = schedulerConnectDataTimeout;
    }

    @Override
    public int getSchedulerConnectDataFirstDelay() {
        return this.schedulerConnectDataFirstDelay;
    }

    public void setSchedulerConnectDataFirstDelay(int schedulerConnectDataFirstDelay) {
        this.schedulerConnectDataFirstDelay = schedulerConnectDataFirstDelay;
    }

    @Override
    public int getSchedulerConnectDataExpBackOffBound() {
        return this.schedulerConnectDataExpBackOffBound;
    }

    public void setSchedulerConnectDataExpBackOffBound(int schedulerConnectDataExpBackOffBound) {
        this.schedulerConnectDataExpBackOffBound = schedulerConnectDataExpBackOffBound;
    }

    @Override
    public boolean isStopPushSwitch() {
        return this.stopPushSwitch;
    }

    @Override
    public void setStopPushSwitch(boolean stopPushSwitch) {
        this.stopPushSwitch = stopPushSwitch;
    }

    @Override
    public boolean isBeginDataFetchTask() {
        return this.beginDataFetchTask;
    }

    @Override
    public void setBeginDataFetchTask(boolean beginDataFetchTask) {
        this.beginDataFetchTask = beginDataFetchTask;
    }

    public String getInvalidForeverZones() {
        return this.invalidForeverZones;
    }

    public void setInvalidForeverZones(String invalidForeverZones) {
        this.invalidForeverZones = invalidForeverZones;
    }

    public String getInvalidIgnoreDataidRegex() {
        return this.invalidIgnoreDataidRegex;
    }

    public void setInvalidIgnoreDataidRegex(String invalidIgnoreDataidRegex) {
        this.invalidIgnoreDataidRegex = invalidIgnoreDataidRegex;
    }

    @Override
    public int getAccessDataExecutorMinPoolSize() {
        return this.accessDataExecutorMinPoolSize;
    }

    public void setAccessDataExecutorMinPoolSize(int accessDataExecutorMinPoolSize) {
        this.accessDataExecutorMinPoolSize = accessDataExecutorMinPoolSize;
    }

    @Override
    public int getAccessDataExecutorMaxPoolSize() {
        return this.accessDataExecutorMaxPoolSize;
    }

    public void setAccessDataExecutorMaxPoolSize(int accessDataExecutorMaxPoolSize) {
        this.accessDataExecutorMaxPoolSize = accessDataExecutorMaxPoolSize;
    }

    @Override
    public int getAccessDataExecutorQueueSize() {
        return this.accessDataExecutorQueueSize;
    }

    public void setAccessDataExecutorQueueSize(int accessDataExecutorQueueSize) {
        this.accessDataExecutorQueueSize = accessDataExecutorQueueSize;
    }

    @Override
    public long getAccessDataExecutorKeepAliveTime() {
        return this.accessDataExecutorKeepAliveTime;
    }

    public void setAccessDataExecutorKeepAliveTime(long accessDataExecutorKeepAliveTime) {
        this.accessDataExecutorKeepAliveTime = accessDataExecutorKeepAliveTime;
    }

    public String getPushEmptyDataDataIdPrefixes() {
        return this.pushEmptyDataDataIdPrefixes;
    }

    @Override
    public int getDataChangeExecutorMinPoolSize() {
        return this.dataChangeExecutorMinPoolSize;
    }

    @Override
    public int getDataChangeExecutorMaxPoolSize() {
        return this.dataChangeExecutorMaxPoolSize;
    }

    @Override
    public int getDataChangeExecutorQueueSize() {
        return this.dataChangeExecutorQueueSize;
    }

    @Override
    public long getDataChangeExecutorKeepAliveTime() {
        return this.dataChangeExecutorKeepAliveTime;
    }

    public void setDataChangeExecutorMinPoolSize(int dataChangeExecutorMinPoolSize) {
        this.dataChangeExecutorMinPoolSize = dataChangeExecutorMinPoolSize;
    }

    public void setDataChangeExecutorMaxPoolSize(int dataChangeExecutorMaxPoolSize) {
        this.dataChangeExecutorMaxPoolSize = dataChangeExecutorMaxPoolSize;
    }

    public void setDataChangeExecutorQueueSize(int dataChangeExecutorQueueSize) {
        this.dataChangeExecutorQueueSize = dataChangeExecutorQueueSize;
    }

    public void setDataChangeExecutorKeepAliveTime(long dataChangeExecutorKeepAliveTime) {
        this.dataChangeExecutorKeepAliveTime = dataChangeExecutorKeepAliveTime;
    }

    public void setPushEmptyDataDataIdPrefixes(String pushEmptyDataDataIdPrefixes) {
        this.pushEmptyDataDataIdPrefixes = pushEmptyDataDataIdPrefixes;
    }

    @Override
    public int getPushTaskExecutorMinPoolSize() {
        return this.pushTaskExecutorMinPoolSize;
    }

    @Override
    public int getPushTaskExecutorMaxPoolSize() {
        return this.pushTaskExecutorMaxPoolSize;
    }

    @Override
    public int getPushTaskExecutorQueueSize() {
        return this.pushTaskExecutorQueueSize;
    }

    @Override
    public long getPushTaskExecutorKeepAliveTime() {
        return this.pushTaskExecutorKeepAliveTime;
    }

    public void setPushTaskExecutorMinPoolSize(int pushTaskExecutorMinPoolSize) {
        this.pushTaskExecutorMinPoolSize = pushTaskExecutorMinPoolSize;
    }

    public void setPushTaskExecutorMaxPoolSize(int pushTaskExecutorMaxPoolSize) {
        this.pushTaskExecutorMaxPoolSize = pushTaskExecutorMaxPoolSize;
    }

    public void setPushTaskExecutorQueueSize(int pushTaskExecutorQueueSize) {
        this.pushTaskExecutorQueueSize = pushTaskExecutorQueueSize;
    }

    public void setPushTaskExecutorKeepAliveTime(long pushTaskExecutorKeepAliveTime) {
        this.pushTaskExecutorKeepAliveTime = pushTaskExecutorKeepAliveTime;
    }

    public Set<String> getPushEmptyDataDataIdPrefixesSet() {
        if (this.pushEmptyDataDataIdPrefixesSet == null || this.pushEmptyDataDataIdPrefixesSet.isEmpty()) {
            String[] arr;
            HashSet<String> s = new HashSet<String>();
            for (String str : arr = this.pushEmptyDataDataIdPrefixes.split(";")) {
                if (str.trim().length() <= 0) continue;
                s.add(str);
            }
            this.pushEmptyDataDataIdPrefixesSet = Collections.unmodifiableSet(s);
        }
        return this.pushEmptyDataDataIdPrefixesSet;
    }

    public void setPushEmptyDataDataIdPrefixesSet(Set<String> pushEmptyDataDataIdPrefixesSet) {
        this.pushEmptyDataDataIdPrefixesSet = pushEmptyDataDataIdPrefixesSet;
    }

    public int getDefaultSessionExecutorMinPoolSize() {
        return this.defaultSessionExecutorMinPoolSize;
    }

    public int getDefaultSessionExecutorMaxPoolSize() {
        return this.defaultSessionExecutorMaxPoolSize;
    }

    public long getDefaultSessionExecutorKeepAliveTime() {
        return this.defaultSessionExecutorKeepAliveTime;
    }

    public void setDefaultSessionExecutorMinPoolSize(int defaultSessionExecutorMinPoolSize) {
        this.defaultSessionExecutorMinPoolSize = defaultSessionExecutorMinPoolSize;
    }

    public void setDefaultSessionExecutorMaxPoolSize(int defaultSessionExecutorMaxPoolSize) {
        this.defaultSessionExecutorMaxPoolSize = defaultSessionExecutorMaxPoolSize;
    }

    public void setDefaultSessionExecutorKeepAliveTime(long defaultSessionExecutorKeepAliveTime) {
        this.defaultSessionExecutorKeepAliveTime = defaultSessionExecutorKeepAliveTime;
    }

    @Override
    public int getDisconnectClientExecutorMinPoolSize() {
        return this.disconnectClientExecutorMinPoolSize;
    }

    public void setDisconnectClientExecutorMinPoolSize(int disconnectClientExecutorMinPoolSize) {
        this.disconnectClientExecutorMinPoolSize = disconnectClientExecutorMinPoolSize;
    }

    @Override
    public int getDisconnectClientExecutorMaxPoolSize() {
        return this.disconnectClientExecutorMaxPoolSize;
    }

    public void setDisconnectClientExecutorMaxPoolSize(int disconnectClientExecutorMaxPoolSize) {
        this.disconnectClientExecutorMaxPoolSize = disconnectClientExecutorMaxPoolSize;
    }

    @Override
    public int getDisconnectClientExecutorQueueSize() {
        return this.disconnectClientExecutorQueueSize;
    }

    public void setDisconnectClientExecutorQueueSize(int disconnectClientExecutorQueueSize) {
        this.disconnectClientExecutorQueueSize = disconnectClientExecutorQueueSize;
    }

    @Override
    public int getDataChangeFetchTaskMaxBufferSize() {
        return this.dataChangeFetchTaskMaxBufferSize;
    }

    public void setDataChangeFetchTaskMaxBufferSize(int dataChangeFetchTaskMaxBufferSize) {
        this.dataChangeFetchTaskMaxBufferSize = dataChangeFetchTaskMaxBufferSize;
    }

    @Override
    public int getDataChangeFetchTaskWorkerSize() {
        return this.dataChangeFetchTaskWorkerSize;
    }

    public void setDataChangeFetchTaskWorkerSize(int dataChangeFetchTaskWorkerSize) {
        this.dataChangeFetchTaskWorkerSize = dataChangeFetchTaskWorkerSize;
    }

    @Override
    public int getUserDataPushRetryWheelTicksSize() {
        return this.userDataPushRetryWheelTicksSize;
    }

    public void setUserDataPushRetryWheelTicksSize(int userDataPushRetryWheelTicksSize) {
        this.userDataPushRetryWheelTicksSize = userDataPushRetryWheelTicksSize;
    }

    @Override
    public int getUserDataPushRetryWheelTicksDuration() {
        return this.userDataPushRetryWheelTicksDuration;
    }

    public void setUserDataPushRetryWheelTicksDuration(int userDataPushRetryWheelTicksDuration) {
        this.userDataPushRetryWheelTicksDuration = userDataPushRetryWheelTicksDuration;
    }

    @Override
    public int getPushDataTaskRetryFirstDelay() {
        return this.pushDataTaskRetryFirstDelay;
    }

    public void setPushDataTaskRetryFirstDelay(int pushDataTaskRetryFirstDelay) {
        this.pushDataTaskRetryFirstDelay = pushDataTaskRetryFirstDelay;
    }

    @Override
    public long getPushDataTaskRetryIncrementDelay() {
        return this.pushDataTaskRetryIncrementDelay;
    }

    public void setPushDataTaskRetryIncrementDelay(long pushDataTaskRetryIncrementDelay) {
        this.pushDataTaskRetryIncrementDelay = pushDataTaskRetryIncrementDelay;
    }

    @Override
    public boolean isInvalidForeverZone(String zoneId) {
        String[] zoneNameArr = this.getInvalidForeverZones().split(";");
        if (this.invalidForeverZonesSet == null) {
            this.invalidForeverZonesSet = new HashSet<String>();
            for (String str : zoneNameArr) {
                if (str.trim().length() <= 0) continue;
                this.invalidForeverZonesSet.add(str);
            }
        }
        return this.invalidForeverZonesSet.contains(zoneId);
    }

    @Override
    public boolean isInvalidIgnored(String dataId) {
        String invalidIgnoreDataidRegex = this.getInvalidIgnoreDataidRegex();
        if (null != invalidIgnoreDataidRegex && !invalidIgnoreDataidRegex.isEmpty()) {
            this.invalidIgnoreDataIdPattern = Pattern.compile(invalidIgnoreDataidRegex);
        }
        return null != this.invalidIgnoreDataIdPattern && this.invalidIgnoreDataIdPattern.matcher(dataId).find();
    }

    public static int cpus() {
        return Runtime.getRuntime().availableProcessors();
    }
}

