/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractClientHandler;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeExchanger.class);
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger((String)"SESSION-EXCHANGE");
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Resource(name="dataClientHandlers")
    private Collection<AbstractClientHandler> dataClientHandlers;
    @Autowired
    private NodeManager dataNodeManager;

    public Response request(Request request) throws RequestException {
        Response response;
        URL url = request.getRequestUrl();
        try {
            Channel channel;
            Client sessionClient = this.boltExchange.getClient("dataServer");
            if (sessionClient == null) {
                LOGGER.warn("DataNode Exchanger get dataServer connection {} error! Connection can not be null or disconnected!", (Object)url);
                sessionClient = this.boltExchange.connect("dataServer", url, (Object[])this.dataClientHandlers.toArray(new ChannelHandler[this.dataClientHandlers.size()]));
            }
            if ((channel = sessionClient.getChannel(url)) == null) {
                channel = sessionClient.connect(url);
            }
            EXCHANGE_LOGGER.info("DataNode Exchanger request={},url={}", request.getRequestBody(), (Object)url);
            Object result = sessionClient.sendSync(channel, request.getRequestBody(), this.sessionServerConfig.getDataNodeExchangeTimeOut());
            if (result == null) {
                LOGGER.error("DataNode Exchanger request data get null result!Request url:" + url);
                throw new RequestException("DataNode Exchanger request data get null result!", request);
            }
            response = () -> result;
        }
        catch (Exception e) {
            LOGGER.error("DataNode Exchanger request data error!request={},url={}", new Object[]{request.getRequestBody(), url, e});
            throw new RequestException("DataNode Exchanger request data error!Request url:" + url, request, (Throwable)e);
        }
        return response;
    }

    public Client connectServer() {
        Collection dataNodes = this.dataNodeManager.getDataCenterNodes();
        if (dataNodes == null || dataNodes.isEmpty()) {
            this.dataNodeManager.getAllDataCenterNodes();
            dataNodes = this.dataNodeManager.getDataCenterNodes();
        }
        Client dataClient = null;
        for (Node dataNode : dataNodes) {
            URL url;
            block7: {
                if (dataNode.getNodeUrl() == null || dataNode.getNodeUrl().getIpAddress() == null) {
                    LOGGER.error("get data node address error!url{}", (Object)dataNode.getNodeUrl());
                    continue;
                }
                url = new URL(dataNode.getNodeUrl().getIpAddress(), this.sessionServerConfig.getDataServerPort());
                try {
                    dataClient = this.boltExchange.getClient("dataServer");
                    if (dataClient != null) break block7;
                    dataClient = this.boltExchange.connect("dataServer", url, (Object[])this.dataClientHandlers.toArray(new ChannelHandler[this.dataClientHandlers.size()]));
                }
                catch (Exception e) {
                    LOGGER.error("DataNode Exchanger connect DataServer error!url:" + url, (Throwable)e);
                    continue;
                }
            }
            try {
                Channel channel = dataClient.getChannel(url);
                if (channel != null) continue;
                dataClient.connect(url);
            }
            catch (Exception e) {
                LOGGER.error("DataNode Exchanger connect channel error!url:" + url, (Throwable)e);
            }
        }
        return dataClient;
    }
}

