/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.sessionserver.DataPushRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import org.springframework.beans.factory.annotation.Autowired;

public class DataPushRequestHandler
extends AbstractClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataPushRequestHandler.class);
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(DataPushRequestHandler.class, (String)"[Task]");
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger((String)"SESSION-EXCHANGE", (String)"[DataPushRequestHandler]");
    @Autowired
    private TaskListenerManager taskListenerManager;

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }

    public Object reply(Channel channel, Object message) {
        if (!(message instanceof DataPushRequest)) {
            LOGGER.error("Request message type {} is not mach the require data type!", (Object)message.getClass().getName());
            return null;
        }
        DataPushRequest dataPushRequest = (DataPushRequest)message;
        EXCHANGE_LOGGER.info("request={}", (Object)dataPushRequest);
        try {
            this.fireDataPushTask(dataPushRequest);
        }
        catch (Exception e) {
            LOGGER.error("DataPush Request error!", (Throwable)e);
            throw new RuntimeException("DataPush Request error!", e);
        }
        return null;
    }

    private void fireDataPushTask(DataPushRequest dataPushRequest) {
        TaskEvent taskEvent = new TaskEvent((Object)dataPushRequest, TaskEvent.TaskType.DATA_PUSH_TASK);
        TASK_LOGGER.info("send " + taskEvent.getTaskType() + " taskEvent:{}", (Object)taskEvent);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    @Override
    public Class interest() {
        return DataPushRequest.class;
    }
}

