/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.edas.model.v20170801;

import com.aliyuncs.RoaAcsRequest;
import com.aliyuncs.http.MethodType;

/**
 * @author auto create
 * @version 
 */
public class QueryMonitorInfoRequest extends RoaAcsRequest<QueryMonitorInfoResponse> {
	
	public QueryMonitorInfoRequest() {
		super("Edas", "2017-08-01", "QueryMonitorInfo");
		setUriPattern("/pop/v5/monitor/queryMonitorInfo");
		setMethod(MethodType.GET);
	}

	private String metric;

	private String aggregator;

	private Long start;

	private Long end;

	private String interval;

	private String tags;

	public String getMetric() {
		return this.metric;
	}

	public void setMetric(String metric) {
		this.metric = metric;
		if(metric != null){
			putQueryParameter("Metric", metric);
		}
	}

	public String getAggregator() {
		return this.aggregator;
	}

	public void setAggregator(String aggregator) {
		this.aggregator = aggregator;
		if(aggregator != null){
			putQueryParameter("Aggregator", aggregator);
		}
	}

	public Long getStart() {
		return this.start;
	}

	public void setStart(Long start) {
		this.start = start;
		if(start != null){
			putQueryParameter("Start", start.toString());
		}
	}

	public Long getEnd() {
		return this.end;
	}

	public void setEnd(Long end) {
		this.end = end;
		if(end != null){
			putQueryParameter("End", end.toString());
		}
	}

	public String getInterval() {
		return this.interval;
	}

	public void setInterval(String interval) {
		this.interval = interval;
		if(interval != null){
			putQueryParameter("Interval", interval);
		}
	}

	public String getTags() {
		return this.tags;
	}

	public void setTags(String tags) {
		this.tags = tags;
		if(tags != null){
			putQueryParameter("Tags", tags);
		}
	}

	@Override
	public Class<QueryMonitorInfoResponse> getResponseClass() {
		return QueryMonitorInfoResponse.class;
	}

}
