/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize.topic;

import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.model.Base64TopicMessage;
import com.aliyun.mns.model.RawTopicMessage;
import com.aliyun.mns.model.TopicMessage;
import com.aliyun.mns.model.serialize.XMLDeserializer;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TopicMessageDeserializer
extends XMLDeserializer<TopicMessage> {
    private TopicMessage.BodyType messageType;

    public TopicMessageDeserializer(TopicMessage.BodyType type) {
        this.messageType = type;
    }

    @Override
    public TopicMessage deserialize(InputStream stream) throws Exception {
        Document doc = this.getDocumentBuilder().parse(stream);
        Element root = doc.getDocumentElement();
        return this.parseMessage(root);
    }

    private TopicMessage parseMessage(Element root) throws ClientException {
        TopicMessage message = null;
        switch (this.messageType) {
            case BASE64: {
                message = new Base64TopicMessage();
                break;
            }
            case STRING: {
                message = new RawTopicMessage();
            }
        }
        String messageId = this.safeGetElementContent(root, "MessageId", null);
        message.setMessageId(messageId);
        String messageBodyMD5 = this.safeGetElementContent(root, "MessageBodyMD5", null);
        message.setMessageBodyMD5(messageBodyMD5);
        return message;
    }
}

