package com.aliyun.openservices.ons.api.order;

import com.aliyun.openservices.ons.api.Admin;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;


/**
 * 顺序消息生产者接口
 */
public interface OrderProducer extends Admin {
    /**
     * 启动服务
     */
    public void start();


    /**
     * 关闭服务
     */
    public void shutdown();


    /**
     * 发送顺序消息
     * 
     * @param message
     *            消息
     * @param selector
     *            消息选择器
     * @param arg
     *            应用自定义参数，会回传到selector.select()方法中
     * @return 发送结果，含消息Id
     */
    public SendResult send(final Message message, //
            final MessageQueueSelector selector, //
            final Object arg);
}
