/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.CommitCallback;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.RollbackCallback;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;

class IndoubtStateHandler
extends CoordinatorStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(IndoubtStateHandler.class);
    private int inquiries_ = 0;

    IndoubtStateHandler(CoordinatorStateHandler previous) {
        super(previous);
    }

    @Override
    protected TxState getState() {
        return TxState.IN_DOUBT;
    }

    @Override
    protected void onTimeout() {
        if (!this.getCoordinator().getState().equals((Object)this.getState())) {
            return;
        }
        try {
            if ((long)this.inquiries_ < this.getCoordinator().getMaxIndoubtTicks()) {
                ++this.inquiries_;
                if ((long)this.inquiries_ >= this.getCoordinator().getMaxIndoubtTicks() / 2L && this.getCoordinator().getSuperiorRecoveryCoordinator() != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug("Requesting replayCompletion on behalf of coordinator " + this.getCoordinator().getCoordinatorId());
                    }
                    this.getCoordinator().getSuperiorRecoveryCoordinator().replayCompletion((Participant)this.getCoordinator());
                }
            } else if (this.getCoordinator().getSuperiorRecoveryCoordinator() == null) {
                this.removePendingOltpCoordinatorFromTransactionService();
            }
        }
        catch (Exception e) {
            LOGGER.logWarning("Error in timeout of INDOUBT state: " + e.getMessage());
        }
    }

    @Override
    protected void setGlobalSiblingCount(int count) {
    }

    @Override
    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        return 1;
    }

    @Override
    protected void commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        this.commitWithAfterCompletionNotification(new CommitCallback(){

            @Override
            public void doCommit() throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
                IndoubtStateHandler.this.commitFromWithinCallback(false, false);
            }
        });
    }

    @Override
    protected void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

            @Override
            public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                IndoubtStateHandler.this.rollbackFromWithinCallback(true, false);
            }
        });
    }
}

