/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;

class TxTerminatedStateHandler
extends TransactionStateHandler {
    private static Logger LOGGER = LoggerFactory.createLogger(TxTerminatedStateHandler.class);
    private boolean transactionCommitted;

    protected TxTerminatedStateHandler(CompositeTransactionImp ct, TransactionStateHandler handler, boolean transactionCommitted) {
        super(ct, handler);
        this.transactionCommitted = transactionCommitted;
    }

    @Override
    protected CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        throw new IllegalStateException("Transaction no longer active");
    }

    @Override
    protected RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        if (!this.transactionCommitted) {
            try {
                participant.rollback();
            }
            catch (Exception ignore) {
                LOGGER.logTrace("Ignoring error on participant rollback", (Throwable)ignore);
            }
        } else {
            throw new IllegalStateException("Transaction no longer active");
        }
        return this.getCT().getCoordinatorImp();
    }

    @Override
    protected void registerSynchronization(Synchronization sync) throws IllegalStateException, UnsupportedOperationException, SysException {
        throw new IllegalStateException("Transaction no longer active");
    }

    @Override
    protected void addSubTxAwareParticipant(SubTxAwareParticipant subtxaware) throws SysException, IllegalStateException {
        if (this.transactionCommitted) {
            throw new IllegalStateException("Transaction no longer active");
        }
        subtxaware.rolledback((CompositeTransaction)this.getCT());
    }

    @Override
    protected void rollbackWithStateCheck() throws IllegalStateException, SysException {
        if (this.transactionCommitted) {
            throw new IllegalStateException("Transaction no longer active");
        }
    }

    @Override
    protected void commit() throws SysException, IllegalStateException, RollbackException {
        if (!this.transactionCommitted) {
            throw new IllegalStateException("Transaction no longer active");
        }
    }

    @Override
    protected TxState getState() {
        if (this.transactionCommitted) {
            return this.getCT().getCoordinatorImp().getStateWithTwoPhaseCommitDecision();
        }
        return TxState.MARKED_ABORT;
    }
}

