/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event.rdb;

import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.JobEventListener;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbIdentity;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbListener;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEventRdbConfiguration
extends JobEventRdbIdentity
implements JobEventConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JobEventRdbConfiguration.class);
    private final String driverClassName;
    private final String url;
    private final String username;
    private final String password;
    private final JobTraceEvent.LogLevel logLevel;

    @Override
    public JobEventListener createJobEventListener() {
        try {
            return new JobEventRdbListener(this);
        }
        catch (SQLException ex) {
            log.error("Elastic job: create JobEventRdbListener failure, error is: ", (Throwable)ex);
            return null;
        }
    }

    @ConstructorProperties(value={"driverClassName", "url", "username", "password", "logLevel"})
    public JobEventRdbConfiguration(String driverClassName, String url, String username, String password, JobTraceEvent.LogLevel logLevel) {
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.logLevel = logLevel;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public JobTraceEvent.LogLevel getLogLevel() {
        return this.logLevel;
    }
}

