/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.executor;

import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.config.JobRootConfiguration;
import com.dangdang.ddframe.job.event.JobEventBus;
import com.dangdang.ddframe.job.event.JobExecutionEvent;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.exception.JobExecutionEnvironmentException;
import com.dangdang.ddframe.job.exception.JobSystemException;
import com.dangdang.ddframe.job.executor.JobFacade;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.executor.handler.ExecutorServiceHandler;
import com.dangdang.ddframe.job.executor.handler.ExecutorServiceHandlerRegistry;
import com.dangdang.ddframe.job.executor.handler.JobExceptionHandler;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public abstract class AbstractElasticJobExecutor {
    private final JobFacade jobFacade;
    private final JobRootConfiguration jobRootConfig;
    private final String jobName;
    private final ExecutorService executorService;
    private final JobExceptionHandler jobExceptionHandler;
    private final JobEventBus jobEventBus = JobEventBus.getInstance();

    protected AbstractElasticJobExecutor(JobFacade jobFacade) {
        this.jobFacade = jobFacade;
        this.jobRootConfig = jobFacade.loadJobRootConfiguration(true);
        this.jobName = this.jobRootConfig.getTypeConfig().getCoreConfig().getJobName();
        this.executorService = ExecutorServiceHandlerRegistry.getExecutorServiceHandler(this.jobName, (ExecutorServiceHandler)this.getHandler(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER));
        this.jobExceptionHandler = (JobExceptionHandler)this.getHandler(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER);
        this.jobEventBus.register(this.jobName, this.jobRootConfig.getTypeConfig().getCoreConfig().getJobEventConfigs().values());
    }

    private Object getHandler(JobProperties.JobPropertiesEnum jobPropertiesEnum) {
        String handlerClassName = this.jobRootConfig.getTypeConfig().getCoreConfig().getJobProperties().get(jobPropertiesEnum);
        try {
            Class<?> handlerClass = Class.forName(handlerClassName);
            if (jobPropertiesEnum.getClassType().isAssignableFrom(handlerClass)) {
                return handlerClass.newInstance();
            }
            return this.getDefaultHandler(jobPropertiesEnum, handlerClassName);
        }
        catch (ReflectiveOperationException ex) {
            return this.getDefaultHandler(jobPropertiesEnum, handlerClassName);
        }
    }

    private Object getDefaultHandler(JobProperties.JobPropertiesEnum jobPropertiesEnum, String handlerClassName) {
        this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.WARN, String.format("Cannot instantiation class '%s', use default %s class.", handlerClassName, jobPropertiesEnum.getKey())));
        try {
            return Class.forName(jobPropertiesEnum.getDefaultValue()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new JobSystemException(e);
        }
    }

    public final void execute() {
        this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, "Job execute begin."));
        try {
            this.jobFacade.checkJobExecutionEnvironment();
        }
        catch (JobExecutionEnvironmentException cause) {
            this.jobExceptionHandler.handleException(this.jobName, cause);
        }
        ShardingContexts shardingContexts = this.jobFacade.getShardingContexts();
        if (this.jobFacade.misfireIfNecessary(shardingContexts.getShardingItemParameters().keySet())) {
            this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.DEBUG, "Previous job is still running, misfired job will start after previous job completed."));
            return;
        }
        this.jobFacade.cleanPreviousExecutionInfo();
        try {
            this.jobFacade.beforeJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            this.jobExceptionHandler.handleException(this.jobName, cause);
        }
        this.execute(shardingContexts, JobExecutionEvent.ExecutionSource.NORMAL_TRIGGER);
        this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, String.format("Execute normal completed, sharding context:%s.", shardingContexts)));
        while (this.jobFacade.isExecuteMisfired(shardingContexts.getShardingItemParameters().keySet())) {
            this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, String.format("Execute misfired job, sharding context:%s.", shardingContexts)));
            this.jobFacade.clearMisfire(shardingContexts.getShardingItemParameters().keySet());
            this.execute(shardingContexts, JobExecutionEvent.ExecutionSource.MISFIRE);
            this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, String.format("Misfired job completed, sharding context:%s.", shardingContexts)));
        }
        this.jobFacade.failoverIfNecessary();
        try {
            this.jobFacade.afterJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            this.jobExceptionHandler.handleException(this.jobName, cause);
        }
        this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, "Job execute completed."));
    }

    private void execute(ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        if (shardingContexts.getShardingItemParameters().isEmpty()) {
            this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, String.format("Sharding item is empty, job execution context: '%s'.", shardingContexts)));
            return;
        }
        this.jobFacade.registerJobBegin(shardingContexts);
        try {
            this.process(shardingContexts, executionSource);
        }
        finally {
            this.jobFacade.registerJobCompleted(shardingContexts);
        }
    }

    private void process(final ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        Set<Integer> items = shardingContexts.getShardingItemParameters().keySet();
        if (1 == items.size()) {
            int item = shardingContexts.getShardingItemParameters().keySet().iterator().next();
            JobExecutionEvent jobExecutionEvent = new JobExecutionEvent(this.jobName, executionSource, item);
            this.process(shardingContexts, item, jobExecutionEvent);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(items.size());
        Iterator jobExecutionEvent = items.iterator();
        while (jobExecutionEvent.hasNext()) {
            final int each = (Integer)jobExecutionEvent.next();
            final JobExecutionEvent jobExecutionEvent2 = new JobExecutionEvent(this.jobName, executionSource, each);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractElasticJobExecutor.this.process(shardingContexts, each, jobExecutionEvent2);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(ShardingContexts shardingContexts, int item, JobExecutionEvent jobExecutionEvent) {
        this.jobEventBus.post(jobExecutionEvent);
        this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, String.format("Job executing, item is: '%s'.", item)));
        try {
            this.process(new ShardingContext(shardingContexts, item));
            jobExecutionEvent.executionSuccess();
            this.jobEventBus.post(new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.TRACE, String.format("Job executed, item is: '%s'.", item)));
        }
        catch (Throwable ex) {
            jobExecutionEvent.executionFailure(ex);
            this.jobExceptionHandler.handleException(this.jobName, ex);
        }
        finally {
            this.jobEventBus.post(jobExecutionEvent);
        }
    }

    protected abstract void process(ShardingContext var1);

    protected JobFacade getJobFacade() {
        return this.jobFacade;
    }

    protected JobRootConfiguration getJobRootConfig() {
        return this.jobRootConfig;
    }
}

