// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/quota.proto

package com.google.api;

/**
 * <pre>
 * `QuotaLimit` defines a specific limit that applies over a specified duration
 * for a limit type. There can be at most one limit for a duration and limit
 * type combination defined within a `QuotaGroup`.
 * </pre>
 *
 * Protobuf type {@code google.api.QuotaLimit}
 */
public  final class QuotaLimit extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.QuotaLimit)
    QuotaLimitOrBuilder {
  // Use QuotaLimit.newBuilder() to construct.
  private QuotaLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private QuotaLimit() {
    name_ = "";
    description_ = "";
    defaultLimit_ = 0L;
    maxLimit_ = 0L;
    freeTier_ = 0L;
    duration_ = "";
    metric_ = "";
    unit_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private QuotaLimit(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            description_ = s;
            break;
          }
          case 24: {

            defaultLimit_ = input.readInt64();
            break;
          }
          case 32: {

            maxLimit_ = input.readInt64();
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            duration_ = s;
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 56: {

            freeTier_ = input.readInt64();
            break;
          }
          case 66: {
            java.lang.String s = input.readStringRequireUtf8();

            metric_ = s;
            break;
          }
          case 74: {
            java.lang.String s = input.readStringRequireUtf8();

            unit_ = s;
            break;
          }
          case 82: {
            if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
              values_ = com.google.protobuf.MapField.newMapField(
                  ValuesDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000100;
            }
            com.google.protobuf.MapEntry<java.lang.String, java.lang.Long>
            values__ = input.readMessage(
                ValuesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            values_.getMutableMap().put(
                values__.getKey(), values__.getValue());
            break;
          }
          case 98: {
            java.lang.String s = input.readStringRequireUtf8();

            displayName_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 10:
        return internalGetValues();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.QuotaLimit.class, com.google.api.QuotaLimit.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * Name of the quota limit. The name is used to refer to the limit when
   * overriding the default limit on per-consumer basis.
   * For group-based quota limits, the name must be unique within the quota
   * group. If a name is not provided, it will be generated from the limit_by
   * and duration fields.
   * For metric-based quota limits, the name must be provided, and it must be
   * unique within the service. The name can only include alphanumeric
   * characters as well as '-'.
   * The maximum length of the limit name is 64 characters.
   * The name of a limit is used as a unique identifier for this limit.
   * Therefore, once a limit has been put into use, its name should be
   * immutable. You can use the display_name field to provide a user-friendly
   * name for the limit. The display name can be evolved over time without
   * affecting the identity of the limit.
   * </pre>
   *
   * <code>string name = 6;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Name of the quota limit. The name is used to refer to the limit when
   * overriding the default limit on per-consumer basis.
   * For group-based quota limits, the name must be unique within the quota
   * group. If a name is not provided, it will be generated from the limit_by
   * and duration fields.
   * For metric-based quota limits, the name must be provided, and it must be
   * unique within the service. The name can only include alphanumeric
   * characters as well as '-'.
   * The maximum length of the limit name is 64 characters.
   * The name of a limit is used as a unique identifier for this limit.
   * Therefore, once a limit has been put into use, its name should be
   * immutable. You can use the display_name field to provide a user-friendly
   * name for the limit. The display name can be evolved over time without
   * affecting the identity of the limit.
   * </pre>
   *
   * <code>string name = 6;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   * <pre>
   * Optional. User-visible, extended description for this quota limit.
   * Should be used only when more context is needed to understand this limit
   * than provided by the limit's display name (see: `display_name`).
   * </pre>
   *
   * <code>string description = 2;</code>
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. User-visible, extended description for this quota limit.
   * Should be used only when more context is needed to understand this limit
   * than provided by the limit's display name (see: `display_name`).
   * </pre>
   *
   * <code>string description = 2;</code>
   */
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LIMIT_FIELD_NUMBER = 3;
  private long defaultLimit_;
  /**
   * <pre>
   * Default number of tokens that can be consumed during the specified
   * duration. This is the number of tokens assigned when a client
   * application developer activates the service for his/her project.
   * Specifying a value of 0 will block all requests. This can be used if you
   * are provisioning quota to selected consumers and blocking others.
   * Similarly, a value of -1 will indicate an unlimited quota. No other
   * negative values are allowed.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>int64 default_limit = 3;</code>
   */
  public long getDefaultLimit() {
    return defaultLimit_;
  }

  public static final int MAX_LIMIT_FIELD_NUMBER = 4;
  private long maxLimit_;
  /**
   * <pre>
   * Maximum number of tokens that can be consumed during the specified
   * duration. Client application developers can override the default limit up
   * to this maximum. If specified, this value cannot be set to a value less
   * than the default limit. If not specified, it is set to the default limit.
   * To allow clients to apply overrides with no upper bound, set this to -1,
   * indicating unlimited maximum quota.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>int64 max_limit = 4;</code>
   */
  public long getMaxLimit() {
    return maxLimit_;
  }

  public static final int FREE_TIER_FIELD_NUMBER = 7;
  private long freeTier_;
  /**
   * <pre>
   * Free tier value displayed in the Developers Console for this limit.
   * The free tier is the number of tokens that will be subtracted from the
   * billed amount when billing is enabled.
   * This field can only be set on a limit with duration "1d", in a billable
   * group; it is invalid on any other limit. If this field is not set, it
   * defaults to 0, indicating that there is no free tier for this service.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>int64 free_tier = 7;</code>
   */
  public long getFreeTier() {
    return freeTier_;
  }

  public static final int DURATION_FIELD_NUMBER = 5;
  private volatile java.lang.Object duration_;
  /**
   * <pre>
   * Duration of this limit in textual notation. Example: "100s", "24h", "1d".
   * For duration longer than a day, only multiple of days is supported. We
   * support only "100s" and "1d" for now. Additional support will be added in
   * the future. "0" indicates indefinite duration.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>string duration = 5;</code>
   */
  public java.lang.String getDuration() {
    java.lang.Object ref = duration_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      duration_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Duration of this limit in textual notation. Example: "100s", "24h", "1d".
   * For duration longer than a day, only multiple of days is supported. We
   * support only "100s" and "1d" for now. Additional support will be added in
   * the future. "0" indicates indefinite duration.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>string duration = 5;</code>
   */
  public com.google.protobuf.ByteString
      getDurationBytes() {
    java.lang.Object ref = duration_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      duration_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_FIELD_NUMBER = 8;
  private volatile java.lang.Object metric_;
  /**
   * <pre>
   * The name of the metric this quota limit applies to. The quota limits with
   * the same metric will be checked together during runtime. The metric must be
   * defined within the service config.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>string metric = 8;</code>
   */
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The name of the metric this quota limit applies to. The quota limits with
   * the same metric will be checked together during runtime. The metric must be
   * defined within the service config.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>string metric = 8;</code>
   */
  public com.google.protobuf.ByteString
      getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIT_FIELD_NUMBER = 9;
  private volatile java.lang.Object unit_;
  /**
   * <pre>
   * Specify the unit of the quota limit. It uses the same syntax as
   * [Metric.unit][]. The supported unit kinds are determined by the quota
   * backend system.
   * The [Google Service Control](https://cloud.google.com/service-control)
   * supports the following unit components:
   * * One of the time intevals:
   *   * "/min"  for quota every minute.
   *   * "/d"  for quota every 24 hours, starting 00:00 US Pacific Time.
   *   * Otherwise the quota won't be reset by time, such as storage limit.
   * * One and only one of the granted containers:
   *   * "/{organization}" quota for an organization.
   *   * "/{project}" quota for a project.
   *   * "/{folder}" quota for a folder.
   *   * "/{resource}" quota for a universal resource.
   * * Zero or more quota segmentation dimension. Not all combos are valid.
   *   * "/{region}" quota for every region. Not to be used with time intervals.
   *   * Otherwise the resources granted on the target is not segmented.
   *   * "/{zone}" quota for every zone. Not to be used with time intervals.
   *   * Otherwise the resources granted on the target is not segmented.
   *   * "/{resource}" quota for a resource associated with a project or org.
   * Here are some examples:
   * * "1/min/{project}" for quota per minute per project.
   * * "1/min/{user}" for quota per minute per user.
   * * "1/min/{organization}" for quota per minute per organization.
   * Note: the order of unit components is insignificant.
   * The "1" at the beginning is required to follow the metric unit syntax.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>string unit = 9;</code>
   */
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specify the unit of the quota limit. It uses the same syntax as
   * [Metric.unit][]. The supported unit kinds are determined by the quota
   * backend system.
   * The [Google Service Control](https://cloud.google.com/service-control)
   * supports the following unit components:
   * * One of the time intevals:
   *   * "/min"  for quota every minute.
   *   * "/d"  for quota every 24 hours, starting 00:00 US Pacific Time.
   *   * Otherwise the quota won't be reset by time, such as storage limit.
   * * One and only one of the granted containers:
   *   * "/{organization}" quota for an organization.
   *   * "/{project}" quota for a project.
   *   * "/{folder}" quota for a folder.
   *   * "/{resource}" quota for a universal resource.
   * * Zero or more quota segmentation dimension. Not all combos are valid.
   *   * "/{region}" quota for every region. Not to be used with time intervals.
   *   * Otherwise the resources granted on the target is not segmented.
   *   * "/{zone}" quota for every zone. Not to be used with time intervals.
   *   * Otherwise the resources granted on the target is not segmented.
   *   * "/{resource}" quota for a resource associated with a project or org.
   * Here are some examples:
   * * "1/min/{project}" for quota per minute per project.
   * * "1/min/{user}" for quota per minute per user.
   * * "1/min/{organization}" for quota per minute per organization.
   * Note: the order of unit components is insignificant.
   * The "1" at the beginning is required to follow the metric unit syntax.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>string unit = 9;</code>
   */
  public com.google.protobuf.ByteString
      getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUES_FIELD_NUMBER = 10;
  private static final class ValuesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, java.lang.Long> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, java.lang.Long>newDefaultInstance(
                com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_ValuesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.INT64,
                0L);
  }
  private com.google.protobuf.MapField<
      java.lang.String, java.lang.Long> values_;
  private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
  internalGetValues() {
    if (values_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ValuesDefaultEntryHolder.defaultEntry);
    }
    return values_;
  }

  public int getValuesCount() {
    return internalGetValues().getMap().size();
  }
  /**
   * <pre>
   * Tiered limit values. Also allows for regional or zone overrides for these
   * values if "/{region}" or "/{zone}" is specified in the unit field.
   * Currently supported tiers from low to high:
   * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
   * To apply different limit values for users according to their tiers, specify
   * the values for the tiers you want to differentiate. For example:
   * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
   * The limit value for each tier is optional except for the tier STANDARD.
   * The limit value for an unspecified tier falls to the value of its next
   * tier towards tier STANDARD. For the above example, the limit value for tier
   * STANDARD is 500.
   * To apply the same limit value for all users, just specify limit value for
   * tier STANDARD. For example: {STANDARD:500}.
   * To apply a regional overide for a tier, add a map entry with key
   * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
   * override, add a map entry with key "&lt;TIER&gt;/{zone}".
   * Further, a wildcard can be used at the end of a zone name in order to
   * specify zone level overrides. For example:
   * LOW: 10, STANDARD: 50, HIGH: 100,
   * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
   * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
   * The regional overrides tier set for each region must be the same as
   * the tier set for default limit values. Same rule applies for zone overrides
   * tier as well.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */

  public boolean containsValues(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetValues().getMap().containsKey(key);
  }
  /**
   * Use {@link #getValuesMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Long> getValues() {
    return getValuesMap();
  }
  /**
   * <pre>
   * Tiered limit values. Also allows for regional or zone overrides for these
   * values if "/{region}" or "/{zone}" is specified in the unit field.
   * Currently supported tiers from low to high:
   * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
   * To apply different limit values for users according to their tiers, specify
   * the values for the tiers you want to differentiate. For example:
   * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
   * The limit value for each tier is optional except for the tier STANDARD.
   * The limit value for an unspecified tier falls to the value of its next
   * tier towards tier STANDARD. For the above example, the limit value for tier
   * STANDARD is 500.
   * To apply the same limit value for all users, just specify limit value for
   * tier STANDARD. For example: {STANDARD:500}.
   * To apply a regional overide for a tier, add a map entry with key
   * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
   * override, add a map entry with key "&lt;TIER&gt;/{zone}".
   * Further, a wildcard can be used at the end of a zone name in order to
   * specify zone level overrides. For example:
   * LOW: 10, STANDARD: 50, HIGH: 100,
   * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
   * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
   * The regional overrides tier set for each region must be the same as
   * the tier set for default limit values. Same rule applies for zone overrides
   * tier as well.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */

  public java.util.Map<java.lang.String, java.lang.Long> getValuesMap() {
    return internalGetValues().getMap();
  }
  /**
   * <pre>
   * Tiered limit values. Also allows for regional or zone overrides for these
   * values if "/{region}" or "/{zone}" is specified in the unit field.
   * Currently supported tiers from low to high:
   * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
   * To apply different limit values for users according to their tiers, specify
   * the values for the tiers you want to differentiate. For example:
   * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
   * The limit value for each tier is optional except for the tier STANDARD.
   * The limit value for an unspecified tier falls to the value of its next
   * tier towards tier STANDARD. For the above example, the limit value for tier
   * STANDARD is 500.
   * To apply the same limit value for all users, just specify limit value for
   * tier STANDARD. For example: {STANDARD:500}.
   * To apply a regional overide for a tier, add a map entry with key
   * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
   * override, add a map entry with key "&lt;TIER&gt;/{zone}".
   * Further, a wildcard can be used at the end of a zone name in order to
   * specify zone level overrides. For example:
   * LOW: 10, STANDARD: 50, HIGH: 100,
   * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
   * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
   * The regional overrides tier set for each region must be the same as
   * the tier set for default limit values. Same rule applies for zone overrides
   * tier as well.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */

  public long getValuesOrDefault(
      java.lang.String key,
      long defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, java.lang.Long> map =
        internalGetValues().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Tiered limit values. Also allows for regional or zone overrides for these
   * values if "/{region}" or "/{zone}" is specified in the unit field.
   * Currently supported tiers from low to high:
   * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
   * To apply different limit values for users according to their tiers, specify
   * the values for the tiers you want to differentiate. For example:
   * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
   * The limit value for each tier is optional except for the tier STANDARD.
   * The limit value for an unspecified tier falls to the value of its next
   * tier towards tier STANDARD. For the above example, the limit value for tier
   * STANDARD is 500.
   * To apply the same limit value for all users, just specify limit value for
   * tier STANDARD. For example: {STANDARD:500}.
   * To apply a regional overide for a tier, add a map entry with key
   * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
   * override, add a map entry with key "&lt;TIER&gt;/{zone}".
   * Further, a wildcard can be used at the end of a zone name in order to
   * specify zone level overrides. For example:
   * LOW: 10, STANDARD: 50, HIGH: 100,
   * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
   * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
   * The regional overrides tier set for each region must be the same as
   * the tier set for default limit values. Same rule applies for zone overrides
   * tier as well.
   * Used by metric-based quotas only.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */

  public long getValuesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, java.lang.Long> map =
        internalGetValues().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 12;
  private volatile java.lang.Object displayName_;
  /**
   * <pre>
   * User-visible display name for this limit.
   * Optional. If not set, the UI will provide a default display name based on
   * the quota configuration. This field can be used to override the default
   * display name generated from the configuration.
   * </pre>
   *
   * <code>string display_name = 12;</code>
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * User-visible display name for this limit.
   * Optional. If not set, the UI will provide a default display name based on
   * the quota configuration. This field can be used to override the default
   * display name generated from the configuration.
   * </pre>
   *
   * <code>string display_name = 12;</code>
   */
  public com.google.protobuf.ByteString
      getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (defaultLimit_ != 0L) {
      output.writeInt64(3, defaultLimit_);
    }
    if (maxLimit_ != 0L) {
      output.writeInt64(4, maxLimit_);
    }
    if (!getDurationBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, duration_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    if (freeTier_ != 0L) {
      output.writeInt64(7, freeTier_);
    }
    if (!getMetricBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, metric_);
    }
    if (!getUnitBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, unit_);
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetValues(),
        ValuesDefaultEntryHolder.defaultEntry,
        10);
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, displayName_);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (defaultLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(3, defaultLimit_);
    }
    if (maxLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(4, maxLimit_);
    }
    if (!getDurationBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, duration_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    if (freeTier_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(7, freeTier_);
    }
    if (!getMetricBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, metric_);
    }
    if (!getUnitBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, unit_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry
         : internalGetValues().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Long>
      values__ = ValuesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, values__);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, displayName_);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.QuotaLimit)) {
      return super.equals(obj);
    }
    com.google.api.QuotaLimit other = (com.google.api.QuotaLimit) obj;

    boolean result = true;
    result = result && getName()
        .equals(other.getName());
    result = result && getDescription()
        .equals(other.getDescription());
    result = result && (getDefaultLimit()
        == other.getDefaultLimit());
    result = result && (getMaxLimit()
        == other.getMaxLimit());
    result = result && (getFreeTier()
        == other.getFreeTier());
    result = result && getDuration()
        .equals(other.getDuration());
    result = result && getMetric()
        .equals(other.getMetric());
    result = result && getUnit()
        .equals(other.getUnit());
    result = result && internalGetValues().equals(
        other.internalGetValues());
    result = result && getDisplayName()
        .equals(other.getDisplayName());
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + DEFAULT_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getDefaultLimit());
    hash = (37 * hash) + MAX_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getMaxLimit());
    hash = (37 * hash) + FREE_TIER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getFreeTier());
    hash = (37 * hash) + DURATION_FIELD_NUMBER;
    hash = (53 * hash) + getDuration().hashCode();
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    if (!internalGetValues().getMap().isEmpty()) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetValues().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.QuotaLimit parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.QuotaLimit parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.QuotaLimit parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.QuotaLimit parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.QuotaLimit parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.QuotaLimit parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.QuotaLimit parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.api.QuotaLimit parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.QuotaLimit parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.QuotaLimit parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.QuotaLimit prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * `QuotaLimit` defines a specific limit that applies over a specified duration
   * for a limit type. There can be at most one limit for a duration and limit
   * type combination defined within a `QuotaGroup`.
   * </pre>
   *
   * Protobuf type {@code google.api.QuotaLimit}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.QuotaLimit)
      com.google.api.QuotaLimitOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 10:
          return internalGetValues();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableValues();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.QuotaLimit.class, com.google.api.QuotaLimit.Builder.class);
    }

    // Construct using com.google.api.QuotaLimit.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      defaultLimit_ = 0L;

      maxLimit_ = 0L;

      freeTier_ = 0L;

      duration_ = "";

      metric_ = "";

      unit_ = "";

      internalGetMutableValues().clear();
      displayName_ = "";

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_descriptor;
    }

    public com.google.api.QuotaLimit getDefaultInstanceForType() {
      return com.google.api.QuotaLimit.getDefaultInstance();
    }

    public com.google.api.QuotaLimit build() {
      com.google.api.QuotaLimit result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.api.QuotaLimit buildPartial() {
      com.google.api.QuotaLimit result = new com.google.api.QuotaLimit(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      result.description_ = description_;
      result.defaultLimit_ = defaultLimit_;
      result.maxLimit_ = maxLimit_;
      result.freeTier_ = freeTier_;
      result.duration_ = duration_;
      result.metric_ = metric_;
      result.unit_ = unit_;
      result.values_ = internalGetValues();
      result.values_.makeImmutable();
      result.displayName_ = displayName_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.QuotaLimit) {
        return mergeFrom((com.google.api.QuotaLimit)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.QuotaLimit other) {
      if (other == com.google.api.QuotaLimit.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.getDefaultLimit() != 0L) {
        setDefaultLimit(other.getDefaultLimit());
      }
      if (other.getMaxLimit() != 0L) {
        setMaxLimit(other.getMaxLimit());
      }
      if (other.getFreeTier() != 0L) {
        setFreeTier(other.getFreeTier());
      }
      if (!other.getDuration().isEmpty()) {
        duration_ = other.duration_;
        onChanged();
      }
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        onChanged();
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        onChanged();
      }
      internalGetMutableValues().mergeFrom(
          other.internalGetValues());
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.QuotaLimit parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.QuotaLimit) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Name of the quota limit. The name is used to refer to the limit when
     * overriding the default limit on per-consumer basis.
     * For group-based quota limits, the name must be unique within the quota
     * group. If a name is not provided, it will be generated from the limit_by
     * and duration fields.
     * For metric-based quota limits, the name must be provided, and it must be
     * unique within the service. The name can only include alphanumeric
     * characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * The name of a limit is used as a unique identifier for this limit.
     * Therefore, once a limit has been put into use, its name should be
     * immutable. You can use the display_name field to provide a user-friendly
     * name for the limit. The display name can be evolved over time without
     * affecting the identity of the limit.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Name of the quota limit. The name is used to refer to the limit when
     * overriding the default limit on per-consumer basis.
     * For group-based quota limits, the name must be unique within the quota
     * group. If a name is not provided, it will be generated from the limit_by
     * and duration fields.
     * For metric-based quota limits, the name must be provided, and it must be
     * unique within the service. The name can only include alphanumeric
     * characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * The name of a limit is used as a unique identifier for this limit.
     * Therefore, once a limit has been put into use, its name should be
     * immutable. You can use the display_name field to provide a user-friendly
     * name for the limit. The display name can be evolved over time without
     * affecting the identity of the limit.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Name of the quota limit. The name is used to refer to the limit when
     * overriding the default limit on per-consumer basis.
     * For group-based quota limits, the name must be unique within the quota
     * group. If a name is not provided, it will be generated from the limit_by
     * and duration fields.
     * For metric-based quota limits, the name must be provided, and it must be
     * unique within the service. The name can only include alphanumeric
     * characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * The name of a limit is used as a unique identifier for this limit.
     * Therefore, once a limit has been put into use, its name should be
     * immutable. You can use the display_name field to provide a user-friendly
     * name for the limit. The display name can be evolved over time without
     * affecting the identity of the limit.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of the quota limit. The name is used to refer to the limit when
     * overriding the default limit on per-consumer basis.
     * For group-based quota limits, the name must be unique within the quota
     * group. If a name is not provided, it will be generated from the limit_by
     * and duration fields.
     * For metric-based quota limits, the name must be provided, and it must be
     * unique within the service. The name can only include alphanumeric
     * characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * The name of a limit is used as a unique identifier for this limit.
     * Therefore, once a limit has been put into use, its name should be
     * immutable. You can use the display_name field to provide a user-friendly
     * name for the limit. The display name can be evolved over time without
     * affecting the identity of the limit.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of the quota limit. The name is used to refer to the limit when
     * overriding the default limit on per-consumer basis.
     * For group-based quota limits, the name must be unique within the quota
     * group. If a name is not provided, it will be generated from the limit_by
     * and duration fields.
     * For metric-based quota limits, the name must be provided, and it must be
     * unique within the service. The name can only include alphanumeric
     * characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * The name of a limit is used as a unique identifier for this limit.
     * Therefore, once a limit has been put into use, its name should be
     * immutable. You can use the display_name field to provide a user-friendly
     * name for the limit. The display name can be evolved over time without
     * affecting the identity of the limit.
     * </pre>
     *
     * <code>string name = 6;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      description_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public Builder clearDescription() {
      
      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      description_ = value;
      onChanged();
      return this;
    }

    private long defaultLimit_ ;
    /**
     * <pre>
     * Default number of tokens that can be consumed during the specified
     * duration. This is the number of tokens assigned when a client
     * application developer activates the service for his/her project.
     * Specifying a value of 0 will block all requests. This can be used if you
     * are provisioning quota to selected consumers and blocking others.
     * Similarly, a value of -1 will indicate an unlimited quota. No other
     * negative values are allowed.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 default_limit = 3;</code>
     */
    public long getDefaultLimit() {
      return defaultLimit_;
    }
    /**
     * <pre>
     * Default number of tokens that can be consumed during the specified
     * duration. This is the number of tokens assigned when a client
     * application developer activates the service for his/her project.
     * Specifying a value of 0 will block all requests. This can be used if you
     * are provisioning quota to selected consumers and blocking others.
     * Similarly, a value of -1 will indicate an unlimited quota. No other
     * negative values are allowed.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 default_limit = 3;</code>
     */
    public Builder setDefaultLimit(long value) {
      
      defaultLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Default number of tokens that can be consumed during the specified
     * duration. This is the number of tokens assigned when a client
     * application developer activates the service for his/her project.
     * Specifying a value of 0 will block all requests. This can be used if you
     * are provisioning quota to selected consumers and blocking others.
     * Similarly, a value of -1 will indicate an unlimited quota. No other
     * negative values are allowed.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 default_limit = 3;</code>
     */
    public Builder clearDefaultLimit() {
      
      defaultLimit_ = 0L;
      onChanged();
      return this;
    }

    private long maxLimit_ ;
    /**
     * <pre>
     * Maximum number of tokens that can be consumed during the specified
     * duration. Client application developers can override the default limit up
     * to this maximum. If specified, this value cannot be set to a value less
     * than the default limit. If not specified, it is set to the default limit.
     * To allow clients to apply overrides with no upper bound, set this to -1,
     * indicating unlimited maximum quota.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 max_limit = 4;</code>
     */
    public long getMaxLimit() {
      return maxLimit_;
    }
    /**
     * <pre>
     * Maximum number of tokens that can be consumed during the specified
     * duration. Client application developers can override the default limit up
     * to this maximum. If specified, this value cannot be set to a value less
     * than the default limit. If not specified, it is set to the default limit.
     * To allow clients to apply overrides with no upper bound, set this to -1,
     * indicating unlimited maximum quota.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 max_limit = 4;</code>
     */
    public Builder setMaxLimit(long value) {
      
      maxLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maximum number of tokens that can be consumed during the specified
     * duration. Client application developers can override the default limit up
     * to this maximum. If specified, this value cannot be set to a value less
     * than the default limit. If not specified, it is set to the default limit.
     * To allow clients to apply overrides with no upper bound, set this to -1,
     * indicating unlimited maximum quota.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 max_limit = 4;</code>
     */
    public Builder clearMaxLimit() {
      
      maxLimit_ = 0L;
      onChanged();
      return this;
    }

    private long freeTier_ ;
    /**
     * <pre>
     * Free tier value displayed in the Developers Console for this limit.
     * The free tier is the number of tokens that will be subtracted from the
     * billed amount when billing is enabled.
     * This field can only be set on a limit with duration "1d", in a billable
     * group; it is invalid on any other limit. If this field is not set, it
     * defaults to 0, indicating that there is no free tier for this service.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 free_tier = 7;</code>
     */
    public long getFreeTier() {
      return freeTier_;
    }
    /**
     * <pre>
     * Free tier value displayed in the Developers Console for this limit.
     * The free tier is the number of tokens that will be subtracted from the
     * billed amount when billing is enabled.
     * This field can only be set on a limit with duration "1d", in a billable
     * group; it is invalid on any other limit. If this field is not set, it
     * defaults to 0, indicating that there is no free tier for this service.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 free_tier = 7;</code>
     */
    public Builder setFreeTier(long value) {
      
      freeTier_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Free tier value displayed in the Developers Console for this limit.
     * The free tier is the number of tokens that will be subtracted from the
     * billed amount when billing is enabled.
     * This field can only be set on a limit with duration "1d", in a billable
     * group; it is invalid on any other limit. If this field is not set, it
     * defaults to 0, indicating that there is no free tier for this service.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 free_tier = 7;</code>
     */
    public Builder clearFreeTier() {
      
      freeTier_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object duration_ = "";
    /**
     * <pre>
     * Duration of this limit in textual notation. Example: "100s", "24h", "1d".
     * For duration longer than a day, only multiple of days is supported. We
     * support only "100s" and "1d" for now. Additional support will be added in
     * the future. "0" indicates indefinite duration.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     */
    public java.lang.String getDuration() {
      java.lang.Object ref = duration_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        duration_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Duration of this limit in textual notation. Example: "100s", "24h", "1d".
     * For duration longer than a day, only multiple of days is supported. We
     * support only "100s" and "1d" for now. Additional support will be added in
     * the future. "0" indicates indefinite duration.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     */
    public com.google.protobuf.ByteString
        getDurationBytes() {
      java.lang.Object ref = duration_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        duration_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Duration of this limit in textual notation. Example: "100s", "24h", "1d".
     * For duration longer than a day, only multiple of days is supported. We
     * support only "100s" and "1d" for now. Additional support will be added in
     * the future. "0" indicates indefinite duration.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     */
    public Builder setDuration(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      duration_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Duration of this limit in textual notation. Example: "100s", "24h", "1d".
     * For duration longer than a day, only multiple of days is supported. We
     * support only "100s" and "1d" for now. Additional support will be added in
     * the future. "0" indicates indefinite duration.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     */
    public Builder clearDuration() {
      
      duration_ = getDefaultInstance().getDuration();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Duration of this limit in textual notation. Example: "100s", "24h", "1d".
     * For duration longer than a day, only multiple of days is supported. We
     * support only "100s" and "1d" for now. Additional support will be added in
     * the future. "0" indicates indefinite duration.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     */
    public Builder setDurationBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      duration_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object metric_ = "";
    /**
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string metric = 8;</code>
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string metric = 8;</code>
     */
    public com.google.protobuf.ByteString
        getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string metric = 8;</code>
     */
    public Builder setMetric(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      metric_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string metric = 8;</code>
     */
    public Builder clearMetric() {
      
      metric_ = getDefaultInstance().getMetric();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string metric = 8;</code>
     */
    public Builder setMetricBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      metric_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object unit_ = "";
    /**
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * The [Google Service Control](https://cloud.google.com/service-control)
     * supports the following unit components:
     * * One of the time intevals:
     *   * "/min"  for quota every minute.
     *   * "/d"  for quota every 24 hours, starting 00:00 US Pacific Time.
     *   * Otherwise the quota won't be reset by time, such as storage limit.
     * * One and only one of the granted containers:
     *   * "/{organization}" quota for an organization.
     *   * "/{project}" quota for a project.
     *   * "/{folder}" quota for a folder.
     *   * "/{resource}" quota for a universal resource.
     * * Zero or more quota segmentation dimension. Not all combos are valid.
     *   * "/{region}" quota for every region. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{zone}" quota for every zone. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{resource}" quota for a resource associated with a project or org.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * * "1/min/{user}" for quota per minute per user.
     * * "1/min/{organization}" for quota per minute per organization.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string unit = 9;</code>
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * The [Google Service Control](https://cloud.google.com/service-control)
     * supports the following unit components:
     * * One of the time intevals:
     *   * "/min"  for quota every minute.
     *   * "/d"  for quota every 24 hours, starting 00:00 US Pacific Time.
     *   * Otherwise the quota won't be reset by time, such as storage limit.
     * * One and only one of the granted containers:
     *   * "/{organization}" quota for an organization.
     *   * "/{project}" quota for a project.
     *   * "/{folder}" quota for a folder.
     *   * "/{resource}" quota for a universal resource.
     * * Zero or more quota segmentation dimension. Not all combos are valid.
     *   * "/{region}" quota for every region. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{zone}" quota for every zone. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{resource}" quota for a resource associated with a project or org.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * * "1/min/{user}" for quota per minute per user.
     * * "1/min/{organization}" for quota per minute per organization.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string unit = 9;</code>
     */
    public com.google.protobuf.ByteString
        getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * The [Google Service Control](https://cloud.google.com/service-control)
     * supports the following unit components:
     * * One of the time intevals:
     *   * "/min"  for quota every minute.
     *   * "/d"  for quota every 24 hours, starting 00:00 US Pacific Time.
     *   * Otherwise the quota won't be reset by time, such as storage limit.
     * * One and only one of the granted containers:
     *   * "/{organization}" quota for an organization.
     *   * "/{project}" quota for a project.
     *   * "/{folder}" quota for a folder.
     *   * "/{resource}" quota for a universal resource.
     * * Zero or more quota segmentation dimension. Not all combos are valid.
     *   * "/{region}" quota for every region. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{zone}" quota for every zone. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{resource}" quota for a resource associated with a project or org.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * * "1/min/{user}" for quota per minute per user.
     * * "1/min/{organization}" for quota per minute per organization.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string unit = 9;</code>
     */
    public Builder setUnit(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      unit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * The [Google Service Control](https://cloud.google.com/service-control)
     * supports the following unit components:
     * * One of the time intevals:
     *   * "/min"  for quota every minute.
     *   * "/d"  for quota every 24 hours, starting 00:00 US Pacific Time.
     *   * Otherwise the quota won't be reset by time, such as storage limit.
     * * One and only one of the granted containers:
     *   * "/{organization}" quota for an organization.
     *   * "/{project}" quota for a project.
     *   * "/{folder}" quota for a folder.
     *   * "/{resource}" quota for a universal resource.
     * * Zero or more quota segmentation dimension. Not all combos are valid.
     *   * "/{region}" quota for every region. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{zone}" quota for every zone. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{resource}" quota for a resource associated with a project or org.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * * "1/min/{user}" for quota per minute per user.
     * * "1/min/{organization}" for quota per minute per organization.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string unit = 9;</code>
     */
    public Builder clearUnit() {
      
      unit_ = getDefaultInstance().getUnit();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * The [Google Service Control](https://cloud.google.com/service-control)
     * supports the following unit components:
     * * One of the time intevals:
     *   * "/min"  for quota every minute.
     *   * "/d"  for quota every 24 hours, starting 00:00 US Pacific Time.
     *   * Otherwise the quota won't be reset by time, such as storage limit.
     * * One and only one of the granted containers:
     *   * "/{organization}" quota for an organization.
     *   * "/{project}" quota for a project.
     *   * "/{folder}" quota for a folder.
     *   * "/{resource}" quota for a universal resource.
     * * Zero or more quota segmentation dimension. Not all combos are valid.
     *   * "/{region}" quota for every region. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{zone}" quota for every zone. Not to be used with time intervals.
     *   * Otherwise the resources granted on the target is not segmented.
     *   * "/{resource}" quota for a resource associated with a project or org.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * * "1/min/{user}" for quota per minute per user.
     * * "1/min/{organization}" for quota per minute per organization.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>string unit = 9;</code>
     */
    public Builder setUnitBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      unit_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, java.lang.Long> values_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
    internalGetValues() {
      if (values_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ValuesDefaultEntryHolder.defaultEntry);
      }
      return values_;
    }
    private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
    internalGetMutableValues() {
      onChanged();;
      if (values_ == null) {
        values_ = com.google.protobuf.MapField.newMapField(
            ValuesDefaultEntryHolder.defaultEntry);
      }
      if (!values_.isMutable()) {
        values_ = values_.copy();
      }
      return values_;
    }

    public int getValuesCount() {
      return internalGetValues().getMap().size();
    }
    /**
     * <pre>
     * Tiered limit values. Also allows for regional or zone overrides for these
     * values if "/{region}" or "/{zone}" is specified in the unit field.
     * Currently supported tiers from low to high:
     * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
     * To apply different limit values for users according to their tiers, specify
     * the values for the tiers you want to differentiate. For example:
     * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
     * The limit value for each tier is optional except for the tier STANDARD.
     * The limit value for an unspecified tier falls to the value of its next
     * tier towards tier STANDARD. For the above example, the limit value for tier
     * STANDARD is 500.
     * To apply the same limit value for all users, just specify limit value for
     * tier STANDARD. For example: {STANDARD:500}.
     * To apply a regional overide for a tier, add a map entry with key
     * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
     * override, add a map entry with key "&lt;TIER&gt;/{zone}".
     * Further, a wildcard can be used at the end of a zone name in order to
     * specify zone level overrides. For example:
     * LOW: 10, STANDARD: 50, HIGH: 100,
     * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
     * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
     * The regional overrides tier set for each region must be the same as
     * the tier set for default limit values. Same rule applies for zone overrides
     * tier as well.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */

    public boolean containsValues(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetValues().getMap().containsKey(key);
    }
    /**
     * Use {@link #getValuesMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getValues() {
      return getValuesMap();
    }
    /**
     * <pre>
     * Tiered limit values. Also allows for regional or zone overrides for these
     * values if "/{region}" or "/{zone}" is specified in the unit field.
     * Currently supported tiers from low to high:
     * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
     * To apply different limit values for users according to their tiers, specify
     * the values for the tiers you want to differentiate. For example:
     * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
     * The limit value for each tier is optional except for the tier STANDARD.
     * The limit value for an unspecified tier falls to the value of its next
     * tier towards tier STANDARD. For the above example, the limit value for tier
     * STANDARD is 500.
     * To apply the same limit value for all users, just specify limit value for
     * tier STANDARD. For example: {STANDARD:500}.
     * To apply a regional overide for a tier, add a map entry with key
     * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
     * override, add a map entry with key "&lt;TIER&gt;/{zone}".
     * Further, a wildcard can be used at the end of a zone name in order to
     * specify zone level overrides. For example:
     * LOW: 10, STANDARD: 50, HIGH: 100,
     * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
     * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
     * The regional overrides tier set for each region must be the same as
     * the tier set for default limit values. Same rule applies for zone overrides
     * tier as well.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */

    public java.util.Map<java.lang.String, java.lang.Long> getValuesMap() {
      return internalGetValues().getMap();
    }
    /**
     * <pre>
     * Tiered limit values. Also allows for regional or zone overrides for these
     * values if "/{region}" or "/{zone}" is specified in the unit field.
     * Currently supported tiers from low to high:
     * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
     * To apply different limit values for users according to their tiers, specify
     * the values for the tiers you want to differentiate. For example:
     * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
     * The limit value for each tier is optional except for the tier STANDARD.
     * The limit value for an unspecified tier falls to the value of its next
     * tier towards tier STANDARD. For the above example, the limit value for tier
     * STANDARD is 500.
     * To apply the same limit value for all users, just specify limit value for
     * tier STANDARD. For example: {STANDARD:500}.
     * To apply a regional overide for a tier, add a map entry with key
     * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
     * override, add a map entry with key "&lt;TIER&gt;/{zone}".
     * Further, a wildcard can be used at the end of a zone name in order to
     * specify zone level overrides. For example:
     * LOW: 10, STANDARD: 50, HIGH: 100,
     * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
     * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
     * The regional overrides tier set for each region must be the same as
     * the tier set for default limit values. Same rule applies for zone overrides
     * tier as well.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */

    public long getValuesOrDefault(
        java.lang.String key,
        long defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, java.lang.Long> map =
          internalGetValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Tiered limit values. Also allows for regional or zone overrides for these
     * values if "/{region}" or "/{zone}" is specified in the unit field.
     * Currently supported tiers from low to high:
     * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
     * To apply different limit values for users according to their tiers, specify
     * the values for the tiers you want to differentiate. For example:
     * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
     * The limit value for each tier is optional except for the tier STANDARD.
     * The limit value for an unspecified tier falls to the value of its next
     * tier towards tier STANDARD. For the above example, the limit value for tier
     * STANDARD is 500.
     * To apply the same limit value for all users, just specify limit value for
     * tier STANDARD. For example: {STANDARD:500}.
     * To apply a regional overide for a tier, add a map entry with key
     * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
     * override, add a map entry with key "&lt;TIER&gt;/{zone}".
     * Further, a wildcard can be used at the end of a zone name in order to
     * specify zone level overrides. For example:
     * LOW: 10, STANDARD: 50, HIGH: 100,
     * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
     * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
     * The regional overrides tier set for each region must be the same as
     * the tier set for default limit values. Same rule applies for zone overrides
     * tier as well.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */

    public long getValuesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, java.lang.Long> map =
          internalGetValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearValues() {
      internalGetMutableValues().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Tiered limit values. Also allows for regional or zone overrides for these
     * values if "/{region}" or "/{zone}" is specified in the unit field.
     * Currently supported tiers from low to high:
     * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
     * To apply different limit values for users according to their tiers, specify
     * the values for the tiers you want to differentiate. For example:
     * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
     * The limit value for each tier is optional except for the tier STANDARD.
     * The limit value for an unspecified tier falls to the value of its next
     * tier towards tier STANDARD. For the above example, the limit value for tier
     * STANDARD is 500.
     * To apply the same limit value for all users, just specify limit value for
     * tier STANDARD. For example: {STANDARD:500}.
     * To apply a regional overide for a tier, add a map entry with key
     * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
     * override, add a map entry with key "&lt;TIER&gt;/{zone}".
     * Further, a wildcard can be used at the end of a zone name in order to
     * specify zone level overrides. For example:
     * LOW: 10, STANDARD: 50, HIGH: 100,
     * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
     * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
     * The regional overrides tier set for each region must be the same as
     * the tier set for default limit values. Same rule applies for zone overrides
     * tier as well.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */

    public Builder removeValues(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableValues().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long>
    getMutableValues() {
      return internalGetMutableValues().getMutableMap();
    }
    /**
     * <pre>
     * Tiered limit values. Also allows for regional or zone overrides for these
     * values if "/{region}" or "/{zone}" is specified in the unit field.
     * Currently supported tiers from low to high:
     * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
     * To apply different limit values for users according to their tiers, specify
     * the values for the tiers you want to differentiate. For example:
     * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
     * The limit value for each tier is optional except for the tier STANDARD.
     * The limit value for an unspecified tier falls to the value of its next
     * tier towards tier STANDARD. For the above example, the limit value for tier
     * STANDARD is 500.
     * To apply the same limit value for all users, just specify limit value for
     * tier STANDARD. For example: {STANDARD:500}.
     * To apply a regional overide for a tier, add a map entry with key
     * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
     * override, add a map entry with key "&lt;TIER&gt;/{zone}".
     * Further, a wildcard can be used at the end of a zone name in order to
     * specify zone level overrides. For example:
     * LOW: 10, STANDARD: 50, HIGH: 100,
     * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
     * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
     * The regional overrides tier set for each region must be the same as
     * the tier set for default limit values. Same rule applies for zone overrides
     * tier as well.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    public Builder putValues(
        java.lang.String key,
        long value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      
      internalGetMutableValues().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Tiered limit values. Also allows for regional or zone overrides for these
     * values if "/{region}" or "/{zone}" is specified in the unit field.
     * Currently supported tiers from low to high:
     * VERY_LOW, LOW, STANDARD, HIGH, VERY_HIGH
     * To apply different limit values for users according to their tiers, specify
     * the values for the tiers you want to differentiate. For example:
     * {LOW:100, STANDARD:500, HIGH:1000, VERY_HIGH:5000}
     * The limit value for each tier is optional except for the tier STANDARD.
     * The limit value for an unspecified tier falls to the value of its next
     * tier towards tier STANDARD. For the above example, the limit value for tier
     * STANDARD is 500.
     * To apply the same limit value for all users, just specify limit value for
     * tier STANDARD. For example: {STANDARD:500}.
     * To apply a regional overide for a tier, add a map entry with key
     * "&lt;TIER&gt;/&lt;region&gt;", where &lt;region&gt; is a region name. Similarly, for a zone
     * override, add a map entry with key "&lt;TIER&gt;/{zone}".
     * Further, a wildcard can be used at the end of a zone name in order to
     * specify zone level overrides. For example:
     * LOW: 10, STANDARD: 50, HIGH: 100,
     * LOW/us-central1: 20, STANDARD/us-central1: 60, HIGH/us-central1: 200,
     * LOW/us-central1-*: 10, STANDARD/us-central1-*: 20, HIGH/us-central1-*: 80
     * The regional overrides tier set for each region must be the same as
     * the tier set for default limit values. Same rule applies for zone overrides
     * tier as well.
     * Used by metric-based quotas only.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */

    public Builder putAllValues(
        java.util.Map<java.lang.String, java.lang.Long> values) {
      internalGetMutableValues().getMutableMap()
          .putAll(values);
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     */
    public com.google.protobuf.ByteString
        getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     */
    public Builder setDisplayName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     */
    public Builder clearDisplayName() {
      
      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     */
    public Builder setDisplayNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      displayName_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.api.QuotaLimit)
  }

  // @@protoc_insertion_point(class_scope:google.api.QuotaLimit)
  private static final com.google.api.QuotaLimit DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.QuotaLimit();
  }

  public static com.google.api.QuotaLimit getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaLimit>
      PARSER = new com.google.protobuf.AbstractParser<QuotaLimit>() {
    public QuotaLimit parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new QuotaLimit(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<QuotaLimit> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaLimit> getParserForType() {
    return PARSER;
  }

  public com.google.api.QuotaLimit getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

