/*
 * Decompiled with CFR 0.152.
 */
package com.hannesdorfmann.mosby3;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.hannesdorfmann.mosby3.mvp.MvpPresenter;
import com.hannesdorfmann.mosby3.mvp.MvpView;
import java.util.Map;

class ActivityScopedCache {
    private final Map<String, PresenterHolder> presenterMap = new ArrayMap();

    ActivityScopedCache() {
    }

    public void clear() {
        this.presenterMap.clear();
    }

    @Nullable
    public <P> P getPresenter(@NonNull String viewId) {
        PresenterHolder holder = this.presenterMap.get(viewId);
        return (P)(holder == null ? null : holder.presenter);
    }

    @Nullable
    public <VS> VS getViewState(@NonNull String viewId) {
        PresenterHolder holder = this.presenterMap.get(viewId);
        return (VS)(holder == null ? null : holder.viewState);
    }

    public void putPresenter(@NonNull String viewId, @NonNull MvpPresenter<? extends MvpView> presenter) {
        if (viewId == null) {
            throw new NullPointerException("ViewId is null");
        }
        if (presenter == null) {
            throw new NullPointerException("Presenter is null");
        }
        PresenterHolder presenterHolder = this.presenterMap.get(viewId);
        if (presenterHolder == null) {
            presenterHolder = new PresenterHolder();
            presenterHolder.presenter = presenter;
            this.presenterMap.put(viewId, presenterHolder);
        } else {
            presenterHolder.presenter = presenter;
        }
    }

    public void putViewState(@NonNull String viewId, @NonNull Object viewState) {
        if (viewId == null) {
            throw new NullPointerException("ViewId is null");
        }
        if (viewState == null) {
            throw new NullPointerException("ViewState is null");
        }
        PresenterHolder presenterHolder = this.presenterMap.get(viewId);
        if (presenterHolder == null) {
            presenterHolder = new PresenterHolder();
            presenterHolder.viewState = viewState;
            this.presenterMap.put(viewId, presenterHolder);
        } else {
            presenterHolder.viewState = viewState;
        }
    }

    public void remove(@NonNull String viewId) {
        if (viewId == null) {
            throw new NullPointerException("View Id is null");
        }
        this.presenterMap.remove(viewId);
    }

    static final class PresenterHolder {
        private MvpPresenter<?> presenter;
        private Object viewState;

        PresenterHolder() {
        }
    }
}

