/*
 * Decompiled with CFR 0.152.
 */
package com.hannesdorfmann.mosby3;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.hannesdorfmann.mosby3.ActivityScopedCache;
import com.hannesdorfmann.mosby3.mvp.MvpPresenter;
import com.hannesdorfmann.mosby3.mvp.MvpView;
import java.util.Map;
import java.util.UUID;

public final class PresenterManager {
    public static boolean DEBUG = false;
    public static final String DEBUG_TAG = "PresenterManager";
    static final String KEY_ACTIVITY_ID = "com.hannesdorfmann.mosby3.MosbyPresenterManagerActivityId";
    private static final Map<Activity, String> activityIdMap = new ArrayMap();
    private static final Map<String, ActivityScopedCache> activityScopedCacheMap = new ArrayMap();
    static final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            String activityId;
            if (savedInstanceState != null && (activityId = savedInstanceState.getString(PresenterManager.KEY_ACTIVITY_ID)) != null) {
                activityIdMap.put(activity, activityId);
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            String activityId = (String)activityIdMap.get(activity);
            if (activityId != null) {
                outState.putString(PresenterManager.KEY_ACTIVITY_ID, activityId);
            }
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityDestroyed(Activity activity) {
            String activityId;
            if (!activity.isChangingConfigurations() && (activityId = (String)activityIdMap.get(activity)) != null) {
                ActivityScopedCache scopedCache = (ActivityScopedCache)activityScopedCacheMap.get(activityId);
                if (scopedCache != null) {
                    scopedCache.clear();
                    activityScopedCacheMap.remove(activityId);
                }
                if (activityScopedCacheMap.isEmpty()) {
                    activity.getApplication().unregisterActivityLifecycleCallbacks(activityLifecycleCallbacks);
                    if (DEBUG) {
                        Log.d((String)PresenterManager.DEBUG_TAG, (String)"Unregistering ActivityLifecycleCallbacks");
                    }
                }
            }
            activityIdMap.remove(activity);
        }
    };

    private PresenterManager() {
        throw new RuntimeException("Not instantiatable!");
    }

    @NonNull
    @MainThread
    static ActivityScopedCache getOrCreateActivityScopedCache(@NonNull Activity activity) {
        ActivityScopedCache activityScopedCache;
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        String activityId = activityIdMap.get(activity);
        if (activityId == null) {
            activityId = UUID.randomUUID().toString();
            activityIdMap.put(activity, activityId);
            if (activityIdMap.size() == 1) {
                activity.getApplication().registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
                if (DEBUG) {
                    Log.d((String)DEBUG_TAG, (String)"Registering ActivityLifecycleCallbacks");
                }
            }
        }
        if ((activityScopedCache = activityScopedCacheMap.get(activityId)) == null) {
            activityScopedCache = new ActivityScopedCache();
            activityScopedCacheMap.put(activityId, activityScopedCache);
        }
        return activityScopedCache;
    }

    @Nullable
    @MainThread
    static ActivityScopedCache getActivityScope(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        String activityId = activityIdMap.get(activity);
        if (activityId == null) {
            return null;
        }
        return activityScopedCacheMap.get(activityId);
    }

    @Nullable
    public static <P> P getPresenter(@NonNull Activity activity, @NonNull String viewId) {
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        if (viewId == null) {
            throw new NullPointerException("View id is null");
        }
        ActivityScopedCache scopedCache = PresenterManager.getActivityScope(activity);
        return scopedCache == null ? null : (P)scopedCache.getPresenter(viewId);
    }

    @Nullable
    public static <VS> VS getViewState(@NonNull Activity activity, @NonNull String viewId) {
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        if (viewId == null) {
            throw new NullPointerException("View id is null");
        }
        ActivityScopedCache scopedCache = PresenterManager.getActivityScope(activity);
        return scopedCache == null ? null : (VS)scopedCache.getViewState(viewId);
    }

    @NonNull
    public static Activity getActivity(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        throw new IllegalStateException("Could not find the surrounding Activity");
    }

    static void reset() {
        activityIdMap.clear();
        for (ActivityScopedCache scopedCache : activityScopedCacheMap.values()) {
            scopedCache.clear();
        }
        activityScopedCacheMap.clear();
    }

    public static void putPresenter(@NonNull Activity activity, @NonNull String viewId, @NonNull MvpPresenter<? extends MvpView> presenter) {
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        ActivityScopedCache scopedCache = PresenterManager.getOrCreateActivityScopedCache(activity);
        scopedCache.putPresenter(viewId, presenter);
    }

    public static void putViewState(@NonNull Activity activity, @NonNull String viewId, @NonNull Object viewState) {
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        ActivityScopedCache scopedCache = PresenterManager.getOrCreateActivityScopedCache(activity);
        scopedCache.putViewState(viewId, viewState);
    }

    public static void remove(@NonNull Activity activity, @NonNull String viewId) {
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        ActivityScopedCache activityScope = PresenterManager.getActivityScope(activity);
        if (activityScope != null) {
            activityScope.remove(viewId);
        }
    }
}

