/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;

public abstract class AbstractClientListenerService
implements ClientListenerService,
MetricsProvider {
    protected final HazelcastClientInstanceImpl client;
    protected final SerializationService serializationService;
    protected final ScheduledExecutorService registrationExecutor;
    protected final ILogger logger;
    @Probe(name="eventHandlerCount", level=ProbeLevel.MANDATORY)
    private final ConcurrentMap<Long, EventHandler> eventHandlerMap = new ConcurrentHashMap<Long, EventHandler>();
    private final StripedExecutor eventExecutor;

    public AbstractClientListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        this.client = client;
        this.serializationService = client.getSerializationService();
        this.logger = client.getLoggingService().getLogger(ClientListenerService.class);
        String name = client.getName();
        this.eventExecutor = new StripedExecutor(this.logger, name + ".event", eventThreadCount, eventQueueCapacity);
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        SingleExecutorThreadFactory threadFactory = new SingleExecutorThreadFactory(classLoader, name + ".eventRegistration-");
        this.registrationExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    @Override
    public void provideMetrics(MetricsRegistry registry) {
        registry.scanAndRegister(this, "listeners");
    }

    @Probe(level=ProbeLevel.MANDATORY)
    private int eventQueueSize() {
        return this.eventExecutor.getWorkQueueSize();
    }

    @Probe(level=ProbeLevel.MANDATORY)
    private long eventsProcessed() {
        return this.eventExecutor.processedCount();
    }

    public void addEventHandler(long callId, EventHandler handler) {
        this.eventHandlerMap.put(callId, handler);
    }

    protected void removeEventHandler(long callId) {
        this.eventHandlerMap.remove(callId);
    }

    public void handleClientMessage(ClientMessage clientMessage, Connection connection) {
        try {
            this.eventExecutor.execute(new ClientEventProcessor(clientMessage, (ClientConnection)connection));
        }
        catch (RejectedExecutionException e) {
            this.logger.warning("Event clientMessage could not be handled", e);
        }
    }

    public void shutdown() {
        this.eventExecutor.shutdown();
        ClientExecutionServiceImpl.shutdownExecutor("registrationExecutor", this.registrationExecutor, this.logger);
    }

    public void start() {
    }

    public StripedExecutor getEventExecutor() {
        return this.eventExecutor;
    }

    public abstract Collection<ClientEventRegistration> getActiveRegistrations(String var1);

    private final class ClientEventProcessor
    implements StripedRunnable {
        final ClientMessage clientMessage;
        final ClientConnection connection;

        private ClientEventProcessor(ClientMessage clientMessage, ClientConnection connection) {
            this.clientMessage = clientMessage;
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long correlationId = this.clientMessage.getCorrelationId();
                EventHandler eventHandler = (EventHandler)AbstractClientListenerService.this.eventHandlerMap.get(correlationId);
                if (eventHandler == null) {
                    AbstractClientListenerService.this.logger.warning("No eventHandler for callId: " + correlationId + ", event: " + this.clientMessage + ", connection: " + this.connection);
                    return;
                }
                eventHandler.handle(this.clientMessage);
            }
            finally {
                this.connection.decrementPendingPacketCount();
            }
        }

        @Override
        public int getKey() {
            return this.clientMessage.getPartitionId();
        }
    }
}

