/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

public enum JavaVersion {
    UNKNOWN,
    JAVA_1_6,
    JAVA_1_7,
    JAVA_1_8,
    JAVA_1_9;

    private static final JavaVersion CURRENT_VERSION;

    public static boolean isAtLeast(JavaVersion version) {
        return JavaVersion.isAtLeast(CURRENT_VERSION, version);
    }

    private static JavaVersion detectCurrentVersion() {
        String version = System.getProperty("java.version");
        return JavaVersion.parseVersion(version);
    }

    static JavaVersion parseVersion(String version) {
        if (version == null) {
            return UNKNOWN;
        }
        if (version.startsWith("1.")) {
            String withoutMajor = version.substring(2, version.length());
            if (withoutMajor.startsWith("6")) {
                return JAVA_1_6;
            }
            if (withoutMajor.startsWith("7")) {
                return JAVA_1_7;
            }
            if (withoutMajor.startsWith("8")) {
                return JAVA_1_8;
            }
            return UNKNOWN;
        }
        if (version.startsWith("9")) {
            return JAVA_1_9;
        }
        return UNKNOWN;
    }

    static boolean isAtLeast(JavaVersion currentVersion, JavaVersion minVersion) {
        return currentVersion.ordinal() >= minVersion.ordinal();
    }

    static {
        CURRENT_VERSION = JavaVersion.detectCurrentVersion();
    }
}

