/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.HazelcastNamespaceHandler;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastTypeBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    private final String type;
    private final String methodName;

    public HazelcastTypeBeanDefinitionParser(String type) {
        this.type = type;
        this.methodName = "get" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        BeanDefinitionBuilder builder = springXmlBuilder.getBuilder();
        builder.setFactoryMethod(this.methodName);
        return builder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;

        SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastInstance.class);
        }

        BeanDefinitionBuilder getBuilder() {
            return this.builder;
        }

        public void handle(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                Node instanceRefNode = attributes.getNamedItem("instance-ref");
                if (instanceRefNode == null) {
                    throw new IllegalStateException("'instance-ref' attribute is required for creating Hazelcast " + HazelcastTypeBeanDefinitionParser.this.type);
                }
                String instanceRef = this.getTextContent(instanceRefNode);
                if (HazelcastNamespaceHandler.CP_TYPES.contains(HazelcastTypeBeanDefinitionParser.this.type)) {
                    this.builder.getRawBeanDefinition().setFactoryBeanName(instanceRef + "@cp-subsystem");
                } else {
                    this.builder.getRawBeanDefinition().setFactoryBeanName(instanceRef);
                }
                this.builder.addDependsOn(instanceRef);
                Node nameNode = attributes.getNamedItem("name");
                if (nameNode == null) {
                    nameNode = attributes.getNamedItem("id");
                }
                this.builder.addConstructorArgValue((Object)this.getTextContent(nameNode));
            }
        }
    }
}

