/*
 * Copyright (c) 2008-2018, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.spi;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.SpiDataSerializerHook;

import java.io.IOException;

/**
 * Default {@link com.hazelcast.spi.ObjectNamespace} implementation for {@link com.hazelcast.core.DistributedObject}.
 *
 * @since 3.9
 */
public final class DistributedObjectNamespace extends DefaultObjectNamespace
        implements ObjectNamespace, IdentifiedDataSerializable {

    public DistributedObjectNamespace() {
    }

    public DistributedObjectNamespace(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    public DistributedObjectNamespace(ObjectNamespace namespace) {
        super(namespace.getServiceName(), namespace.getObjectName());
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(service);
        out.writeUTF(objectName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        service = in.readUTF();
        objectName = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return SpiDataSerializerHook.DISTRIBUTED_OBJECT_NS;
    }
}
