/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.api.types.ServiceType;

public interface ServiceEndpointProvider {
    public String getEndpoint(ServiceType var1);

    public String getEndpoint(ServiceType var1, Facing var2);

    public static class ServiceEndpoint {
        @JsonProperty(value="public")
        String publicEndpoint;
        @JsonProperty(value="admin")
        String adminEndpoint;
        @JsonProperty(value="internal")
        String internalEndpoint;

        public String getEndpointFor(Facing perspective) {
            if (perspective == null) {
                return this.publicEndpoint;
            }
            switch (perspective) {
                case PUBLIC: {
                    return this.publicEndpoint;
                }
                case ADMIN: {
                    return this.adminEndpoint;
                }
                case INTERNAL: {
                    return this.internalEndpoint;
                }
            }
            return this.publicEndpoint;
        }

        public String getPublicEndpoint() {
            return this.publicEndpoint;
        }

        public String getAdminEndpoint() {
            return this.adminEndpoint;
        }

        public String getInternalEndpoint() {
            return this.internalEndpoint;
        }

        public void setPublicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
        }

        public void setAdminEndpoint(String adminEndpoint) {
            this.adminEndpoint = adminEndpoint;
        }

        public void setInternalEndpoint(String internalEndpoint) {
            this.internalEndpoint = internalEndpoint;
        }
    }
}

