/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.api.exceptions;

import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.api.exceptions.AuthenticationException;
import com.huawei.openstack4j.api.exceptions.ClientResponseException;
import com.huawei.openstack4j.api.exceptions.OS4JException;
import com.huawei.openstack4j.api.exceptions.ServerResponseException;

public class ResponseException
extends OS4JException {
    private static final long serialVersionUID = 7294957362769575271L;
    protected int status;

    public ResponseException(String message, int status) {
        super(message);
        this.status = status;
    }

    public ResponseException(String message, int status, Throwable cause) {
        super(message, cause);
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("message", (Object)this.getMessage()).add("status", this.getStatus()).toString();
    }

    public static ResponseException mapException(String message, int status) {
        return ResponseException.mapException(message, status, null);
    }

    public static ResponseException mapException(String message, int status, Throwable cause) {
        if (status == 401) {
            return new AuthenticationException(message, status, cause);
        }
        if (status >= 400 && status < 499) {
            return new ClientResponseException(message, status, cause);
        }
        if (status >= 500 && status < 600) {
            return new ServerResponseException(message, status, cause);
        }
        return new ResponseException(message, status, cause);
    }
}

