/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.core.transport;

import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.HttpResponse;

public class Handle<T> {
    private final HttpResponse response;
    private final Class<T> returnType;
    private final ExecutionOptions<T> options;
    private final boolean requiresVoidBodyHandling;
    private T returnObject;
    private boolean complete;

    private Handle(HttpResponse response, Class<T> returnType, ExecutionOptions<T> options, boolean requiresVoidBodyHandling) {
        this.response = response;
        this.returnType = returnType;
        this.options = options;
        this.requiresVoidBodyHandling = requiresVoidBodyHandling;
    }

    static <T> Handle<T> create(HttpResponse response, Class<T> returnType, ExecutionOptions<T> options, boolean requiresVoidBodyHandling) {
        return new Handle<T>(response, returnType, options, requiresVoidBodyHandling);
    }

    Handle<T> complete(T returnObject) {
        this.complete = true;
        this.returnObject = returnObject;
        return this;
    }

    Handle<T> continueHandling() {
        this.complete = false;
        return this;
    }

    public T getReturnObject() {
        return this.returnObject;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public ExecutionOptions<T> getOptions() {
        return this.options;
    }

    public boolean isRequiresVoidBodyHandling() {
        return this.requiresVoidBodyHandling;
    }
}

