/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.core.transport;

import com.huawei.openstack4j.api.exceptions.AuthenticationException;
import com.huawei.openstack4j.api.exceptions.ClientResponseException;
import com.huawei.openstack4j.api.exceptions.ResponseException;
import com.huawei.openstack4j.api.exceptions.ServerResponseException;

public class HttpExceptionHandler {
    public static ResponseException mapException(String message, int status) {
        return HttpExceptionHandler.mapException(message, status, null);
    }

    public static ResponseException mapException(String message, int status, Throwable cause) {
        if (status == 401) {
            return new AuthenticationException(message, status, cause);
        }
        if (status >= 400 && status < 499) {
            return new ClientResponseException(message, status, cause);
        }
        if (status >= 500 && status < 600) {
            return new ServerResponseException(message, status, cause);
        }
        return new ResponseException(message, status, cause);
    }
}

