/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.core.transport.functions;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.model.common.ActionResponse;
import java.util.Map;

public class ParseActionResponseFromJsonMap
implements Function<Map<String, Object>, ActionResponse> {
    private static final String KEY_MESSAGE = "message";
    private static final String NEUTRON_ERROR = "NeutronError";
    private static final String COMPUTE_FAULT = "computeFault";
    private static final String TACKER_ERROR = "TackerError";
    private static final String CLOUDEYE_ERROR = "details";
    private static final String MAP_REDUCE_ERROR = "error_message";
    private static final String KEY_MANAGEMENT_ERROR_MSG = "error_msg";
    private static final String TROVE_ERROR_CODE = "errCode";
    private static final String TROVE_ERROR_MSG = "externalMessage";
    private static final String[] KEY_CODE_LIST = new String[]{"errCode", "code", "errorCode", "error_code", "Code"};
    private static final String[] KEY_MESSAGE_LIST = new String[]{"externalMessage", "message", "NeutronError", "computeFault", "TackerError", "details", "error_message", "error_msg", "Message"};
    private HttpResponse response;

    public ParseActionResponseFromJsonMap(HttpResponse response) {
        this.response = response;
    }

    /*
     * WARNING - void declaration
     */
    public ActionResponse apply(Map<String, Object> map) {
        void var3_7;
        if (map == null || map.isEmpty()) {
            return null;
        }
        for (String string : map.keySet()) {
            if (!Map.class.isAssignableFrom(map.get(string).getClass())) continue;
            Map inner = (Map)map.get(string);
            String errorCode = "";
            for (String codeKey : KEY_CODE_LIST) {
                if (!inner.containsKey(codeKey)) continue;
                errorCode = "[" + String.valueOf(inner.get(codeKey)) + "] ";
                break;
            }
            String msg = "";
            for (String messageKey : KEY_MESSAGE_LIST) {
                if (!inner.containsKey(messageKey)) continue;
                msg = errorCode + String.valueOf(inner.get(messageKey));
                break;
            }
            if (Strings.isNullOrEmpty((String)msg)) continue;
            return ActionResponse.actionFailed(msg, this.response.getStatus());
        }
        String errorCode = "";
        for (String codeKey : KEY_CODE_LIST) {
            if (!map.containsKey(codeKey)) continue;
            errorCode = "[" + String.valueOf(map.get(codeKey)) + "] ";
            break;
        }
        String string = "";
        for (String messageKey : KEY_MESSAGE_LIST) {
            if (!map.containsKey(messageKey)) continue;
            String string2 = errorCode + String.valueOf(map.get(messageKey));
            break;
        }
        if (!Strings.isNullOrEmpty((String)var3_7.toString())) {
            return ActionResponse.actionFailed(var3_7.toString(), this.response.getStatus());
        }
        return null;
    }
}

