/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.core.transport.functions;

import com.google.common.base.Function;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.core.transport.functions.ParseActionResponseFromJsonMap;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.internal.Parser;
import java.util.Map;

public class ResponseToActionResponse
implements Function<HttpResponse, ActionResponse> {
    public static final ResponseToActionResponse INSTANCE = new ResponseToActionResponse();

    public ActionResponse apply(HttpResponse response) {
        return this.apply(response, false);
    }

    public ActionResponse apply(HttpResponse response, boolean returnNullIfNotMapped) {
        if (Parser.isContentTypeText(response.getContentType())) {
            return ActionResponse.actionFailed(response.getStatusMessage(), response.getStatus());
        }
        Map map = response.readEntity(Map.class);
        ActionResponse ar = new ParseActionResponseFromJsonMap(response).apply(map);
        if (ar != null) {
            return ar;
        }
        if (ar == null && returnNullIfNotMapped) {
            return null;
        }
        return ActionResponse.actionFailed(String.format("Status: %d, Reason: %s", response.getStatus(), response.getStatusMessage()), response.getStatus());
    }
}

