/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.core.transport.internal;

import com.huawei.openstack4j.api.exceptions.ConnectorNotFoundException;
import com.huawei.openstack4j.core.transport.HttpExecutorService;
import com.huawei.openstack4j.core.transport.HttpRequest;
import com.huawei.openstack4j.core.transport.HttpResponse;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HttpExecutor.class);
    private static final HttpExecutor INSTANCE = new HttpExecutor();
    private HttpExecutorService service;

    private HttpExecutor() {
    }

    private HttpExecutorService service() {
        if (this.service != null) {
            return this.service;
        }
        Iterator<HttpExecutorService> it = ServiceLoader.load(HttpExecutorService.class, this.getClass().getClassLoader()).iterator();
        if (!it.hasNext()) {
            LOG.error("No OpenStack4j connector found in classpath");
            throw new ConnectorNotFoundException("No OpenStack4j connector found in classpath");
        }
        this.service = it.next();
        return this.service;
    }

    public static HttpExecutor create() {
        return INSTANCE;
    }

    public String getExecutorName() {
        return this.service().getExecutorDisplayName();
    }

    public <R> HttpResponse execute(HttpRequest<R> request) {
        LOG.debug("Executing Request: {} -> {}", (Object)request.getEndpoint(), (Object)request.getPath());
        return this.service().execute(request);
    }
}

