/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.common.header;

import com.huawei.openstack4j.model.common.header.HeaderNameValue;
import com.huawei.openstack4j.model.common.header.HeaderOption;

public class Range
implements HeaderOption {
    static final String RANGE_HEADER_NAME = "Range";
    static final String RANGE_HEADER_VALUE_PREFIX = "bytes=";
    protected long offset;
    protected long length;

    Range(long offset, long length) {
        this.offset = offset;
        this.length = length;
    }

    public static Range last(long lastBytes) {
        return new Range(-1L, lastBytes);
    }

    public static Range first(long maxBytes) {
        return new Range(0L, maxBytes);
    }

    public static Range startAt(long offset) {
        return new Range(offset, -1L);
    }

    public static Range from(long offset, long lastByte) {
        return new Range(offset, lastByte);
    }

    @Override
    public HeaderNameValue toHeader() {
        return new HeaderNameValue(RANGE_HEADER_NAME, RANGE_HEADER_VALUE_PREFIX + this.value());
    }

    public String value() {
        return (this.offset >= 0L ? Long.toString(this.offset) : "") + "-" + (this.length >= 0L ? Long.toString(this.length) : "");
    }
}

