/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.common.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;

public class BooleanDeserializer
extends JsonDeserializer<Boolean> {
    ArrayList<String> trueValues = Lists.newArrayList((Object[])new String[]{"Y", "1", "YES"});
    ArrayList<String> falseValues = Lists.newArrayList((Object[])new String[]{"N", "0", "NO"});

    public Boolean deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        String value = parser.getText();
        if (value != null) {
            if (this.trueValues.contains(value.toUpperCase())) {
                return true;
            }
            if (this.falseValues.contains(value.toUpperCase())) {
                return false;
            }
        }
        return null;
    }
}

