/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.identity;

import com.huawei.openstack4j.api.ServiceEndpointProvider;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.model.common.resolvers.LatestServiceVersionResolver;
import com.huawei.openstack4j.model.common.resolvers.ServiceVersionResolver;
import com.huawei.openstack4j.model.common.resolvers.StableServiceVersionResolver;
import com.huawei.openstack4j.model.identity.v2.Access;
import com.huawei.openstack4j.model.identity.v3.Token;
import java.util.HashMap;

public class URLResolverParams {
    public Token token;
    public ServiceType type;
    public String region;
    public Facing perspective;
    private ServiceVersionResolver resolver;
    public Access access;
    public String domain;
    public String projectId;
    private HashMap<ServiceType, ServiceEndpointProvider.ServiceEndpoint> serviceEndpoints;

    private URLResolverParams(Token token, ServiceType type) {
        this.token = token;
        this.type = type == null ? ServiceType.IDENTITY : type;
    }

    public static URLResolverParams create(Token token, ServiceType type) {
        return new URLResolverParams(token, type);
    }

    public static URLResolverParams create(Access access, ServiceType type) {
        return new URLResolverParams(access, type);
    }

    private URLResolverParams(ServiceType type) {
        this.type = type == null ? ServiceType.IDENTITY : type;
    }

    public static URLResolverParams create(ServiceType type) {
        return new URLResolverParams(type);
    }

    private URLResolverParams(Access access, ServiceType type) {
        this.access = access;
        this.type = type == null ? ServiceType.IDENTITY : type;
    }

    public URLResolverParams region(String region) {
        this.region = region;
        return this;
    }

    public URLResolverParams perspective(Facing perspective) {
        this.perspective = perspective;
        return this;
    }

    public URLResolverParams resolver(ServiceVersionResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public URLResolverParams serviceEndpoints(HashMap<ServiceType, ServiceEndpointProvider.ServiceEndpoint> serviceEndpoints) {
        this.serviceEndpoints = serviceEndpoints;
        return this;
    }

    public ServiceVersionResolver getResolver() {
        return this.resolver != null ? this.resolver : LatestServiceVersionResolver.INSTANCE;
    }

    public URLResolverParams projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public ServiceVersionResolver getV2Resolver() {
        return this.resolver != null ? this.resolver : StableServiceVersionResolver.INSTANCE;
    }

    public HashMap<ServiceType, ServiceEndpointProvider.ServiceEndpoint> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public URLResolverParams domain(String domain) {
        this.domain = domain;
        return this;
    }
}

