/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.loadbalance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import java.util.Date;

public interface LoadBalancer
extends ModelEntity {
    public String getId();

    public String getName();

    public String getDescription();

    public String getVpcId();

    public Integer getBandwidth();

    public Type getType();

    public Integer getAdminStateUp();

    public String getVipSubnetId();

    public String getSecurityGroupId();

    public String getVipAddress();

    public Status getStatus();

    public Date getCreateTime();

    public Date getUpdateTime();

    public static enum Type {
        INTERNAL("Internal"),
        EXTERNAL("External");

        private String val;

        private Type(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public Type forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (Type type : Type.values()) {
                    if (!type.getVal().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum Status {
        ACTIVE,
        PENDING_CREATE,
        ERROR;


        @JsonCreator
        public Status forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (Status status : Status.values()) {
                    if (!status.name().equalsIgnoreCase(value)) continue;
                    return status;
                }
            }
            return null;
        }
    }
}

