/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.map.reduce;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.common.Buildable;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.map.reduce.DataSourceCredentials;
import com.huawei.openstack4j.model.map.reduce.builder.DataSourceBuilder;
import com.huawei.openstack4j.model.storage.block.AsyncVolumeBackupJob;
import java.util.Date;

public interface DataSource
extends ModelEntity,
Buildable<DataSourceBuilder> {
    public String getDescription();

    public String getURL();

    public String getTenantId();

    public Date getCreatedAt();

    public Date getUpdatedAt();

    public DataSourceType getType();

    public String getId();

    public String getName();

    public DataSourceCredentials getCredentials();

    public Boolean isProtected();

    public Boolean isPublic();

    public static enum DataSourceType {
        HDFS,
        OBS,
        SWIFT;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static AsyncVolumeBackupJob.Status forValue(String value) {
            if (value != null) {
                for (AsyncVolumeBackupJob.Status s : AsyncVolumeBackupJob.Status.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return null;
        }
    }
}

