/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.network;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.huawei.openstack4j.common.Buildable;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.network.builder.AgentBuilder;
import java.util.Date;

public interface Agent
extends ModelEntity,
Buildable<AgentBuilder> {
    public boolean getAdminStateUp();

    public Type getAgentType();

    public boolean getAlive();

    public String getBinary();

    public Date getCreatedAt();

    public String getDescription();

    public Date getHeartbeatTimestamp();

    public String getHost();

    public String getId();

    public Date getStartedAt();

    public String getTopic();

    public static enum Type {
        DHCP("DHCP agent"),
        L3("L3 agent"),
        OPEN_VSWITCH("Open vSwitch agent"),
        METADATA("Metadata agent"),
        UNRECOGNIZED("");

        private String mValue;

        private Type(String value) {
            this.mValue = value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            if (value != null) {
                for (Type s : Type.values()) {
                    if (!s.value().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return UNRECOGNIZED;
        }

        public String value() {
            return this.mValue;
        }
    }
}

