/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.scaling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;

public class Bandwidth
implements ModelEntity {
    private static final long serialVersionUID = -1154665269978660693L;
    @JsonProperty
    private String size;
    @JsonProperty(value="share_type")
    private ShareType shareType;
    @JsonProperty(value="charging_mode")
    private ChargingMode chargingMode;

    public static BandwidthBuilder builder() {
        return new BandwidthBuilder();
    }

    public String getSize() {
        return this.size;
    }

    public ShareType getShareType() {
        return this.shareType;
    }

    public ChargingMode getChargingMode() {
        return this.chargingMode;
    }

    public String toString() {
        return "Bandwidth(size=" + this.getSize() + ", shareType=" + (Object)((Object)this.getShareType()) + ", chargingMode=" + (Object)((Object)this.getChargingMode()) + ")";
    }

    public Bandwidth() {
    }

    @ConstructorProperties(value={"size", "shareType", "chargingMode"})
    public Bandwidth(String size, ShareType shareType, ChargingMode chargingMode) {
        this.size = size;
        this.shareType = shareType;
        this.chargingMode = chargingMode;
    }

    public static class BandwidthBuilder {
        private String size;
        private ShareType shareType;
        private ChargingMode chargingMode;

        BandwidthBuilder() {
        }

        public BandwidthBuilder size(String size) {
            this.size = size;
            return this;
        }

        public BandwidthBuilder shareType(ShareType shareType) {
            this.shareType = shareType;
            return this;
        }

        public BandwidthBuilder chargingMode(ChargingMode chargingMode) {
            this.chargingMode = chargingMode;
            return this;
        }

        public Bandwidth build() {
            return new Bandwidth(this.size, this.shareType, this.chargingMode);
        }

        public String toString() {
            return "Bandwidth.BandwidthBuilder(size=" + this.size + ", shareType=" + (Object)((Object)this.shareType) + ", chargingMode=" + (Object)((Object)this.chargingMode) + ")";
        }
    }

    public static enum ChargingMode {
        TRAFFIC("traffic"),
        BANDWIDTH("bandwidth");

        private String val;

        private ChargingMode(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public ChargingMode forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (ChargingMode mode : ChargingMode.values()) {
                    if (!mode.getVal().equalsIgnoreCase(value)) continue;
                    return mode;
                }
            }
            return null;
        }
    }

    public static enum ShareType {
        PER;


        @JsonCreator
        public ShareType forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (ShareType type : ShareType.values()) {
                    if (!type.name().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

