/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.scaling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;

public class Disk
implements ModelEntity {
    private static final long serialVersionUID = -8180543136177519493L;
    @JsonProperty
    private Integer size;
    @JsonProperty(value="volume_type")
    private VolumeType volumeType;
    @JsonProperty(value="disk_type")
    private DiskType diskType;

    public static DiskBuilder builder() {
        return new DiskBuilder();
    }

    public Integer getSize() {
        return this.size;
    }

    public VolumeType getVolumeType() {
        return this.volumeType;
    }

    public DiskType getDiskType() {
        return this.diskType;
    }

    public String toString() {
        return "Disk(size=" + this.getSize() + ", volumeType=" + (Object)((Object)this.getVolumeType()) + ", diskType=" + (Object)((Object)this.getDiskType()) + ")";
    }

    public Disk() {
    }

    @ConstructorProperties(value={"size", "volumeType", "diskType"})
    public Disk(Integer size, VolumeType volumeType, DiskType diskType) {
        this.size = size;
        this.volumeType = volumeType;
        this.diskType = diskType;
    }

    public static class DiskBuilder {
        private Integer size;
        private VolumeType volumeType;
        private DiskType diskType;

        DiskBuilder() {
        }

        public DiskBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public DiskBuilder volumeType(VolumeType volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public DiskBuilder diskType(DiskType diskType) {
            this.diskType = diskType;
            return this;
        }

        public Disk build() {
            return new Disk(this.size, this.volumeType, this.diskType);
        }

        public String toString() {
            return "Disk.DiskBuilder(size=" + this.size + ", volumeType=" + (Object)((Object)this.volumeType) + ", diskType=" + (Object)((Object)this.diskType) + ")";
        }
    }

    public static enum DiskType {
        DATA,
        SYS;


        @JsonCreator
        public DiskType forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (DiskType type : DiskType.values()) {
                    if (!type.name().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum VolumeType {
        SSD,
        SATA,
        SAS;


        @JsonCreator
        public VolumeType forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (VolumeType type : VolumeType.values()) {
                    if (!type.name().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

