/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.scaling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;
import java.util.Date;

public class ScheduledPolicy
implements ModelEntity {
    private static final long serialVersionUID = -6411187348817338454L;
    @JsonProperty(value="launch_time")
    private String launchTime;
    @JsonProperty(value="recurrence_type")
    private RecurrenceType recurrenceType;
    @JsonProperty(value="recurrence_value")
    private String recurrenceValue;
    @JsonProperty(value="start_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm'Z'")
    private Date startTime;
    @JsonProperty(value="end_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm'Z'")
    private Date endTime;

    public static ScheduledPolicyBuilder builder() {
        return new ScheduledPolicyBuilder();
    }

    public ScheduledPolicyBuilder toBuilder() {
        return new ScheduledPolicyBuilder().launchTime(this.launchTime).recurrenceType(this.recurrenceType).recurrenceValue(this.recurrenceValue).startTime(this.startTime).endTime(this.endTime);
    }

    public String getLaunchTime() {
        return this.launchTime;
    }

    public RecurrenceType getRecurrenceType() {
        return this.recurrenceType;
    }

    public String getRecurrenceValue() {
        return this.recurrenceValue;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return "ScheduledPolicy(launchTime=" + this.getLaunchTime() + ", recurrenceType=" + (Object)((Object)this.getRecurrenceType()) + ", recurrenceValue=" + this.getRecurrenceValue() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }

    public ScheduledPolicy() {
    }

    @ConstructorProperties(value={"launchTime", "recurrenceType", "recurrenceValue", "startTime", "endTime"})
    public ScheduledPolicy(String launchTime, RecurrenceType recurrenceType, String recurrenceValue, Date startTime, Date endTime) {
        this.launchTime = launchTime;
        this.recurrenceType = recurrenceType;
        this.recurrenceValue = recurrenceValue;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static class ScheduledPolicyBuilder {
        private String launchTime;
        private RecurrenceType recurrenceType;
        private String recurrenceValue;
        private Date startTime;
        private Date endTime;

        ScheduledPolicyBuilder() {
        }

        public ScheduledPolicyBuilder launchTime(String launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public ScheduledPolicyBuilder recurrenceType(RecurrenceType recurrenceType) {
            this.recurrenceType = recurrenceType;
            return this;
        }

        public ScheduledPolicyBuilder recurrenceValue(String recurrenceValue) {
            this.recurrenceValue = recurrenceValue;
            return this;
        }

        public ScheduledPolicyBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public ScheduledPolicyBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public ScheduledPolicy build() {
            return new ScheduledPolicy(this.launchTime, this.recurrenceType, this.recurrenceValue, this.startTime, this.endTime);
        }

        public String toString() {
            return "ScheduledPolicy.ScheduledPolicyBuilder(launchTime=" + this.launchTime + ", recurrenceType=" + (Object)((Object)this.recurrenceType) + ", recurrenceValue=" + this.recurrenceValue + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
        }
    }

    public static enum RecurrenceType {
        DAILY("Daily"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly");

        private String val;

        private RecurrenceType(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public RecurrenceType forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (RecurrenceType type : RecurrenceType.values()) {
                    if (!type.name().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

