/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.antiddos.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.openstack.antiddos.domain.AntiDDoS;
import com.huawei.openstack4j.openstack.antiddos.domain.AntiDDoSConfig;
import com.huawei.openstack4j.openstack.antiddos.domain.AntiDDoSDailyData;
import com.huawei.openstack4j.openstack.antiddos.domain.AntiDDoSLog;
import com.huawei.openstack4j.openstack.antiddos.domain.AntiDDoSStatus;
import com.huawei.openstack4j.openstack.antiddos.domain.AntiDDoSStatusDetail;
import com.huawei.openstack4j.openstack.antiddos.domain.AntiDDoSWeeklyData;
import com.huawei.openstack4j.openstack.antiddos.domain.Task;
import com.huawei.openstack4j.openstack.antiddos.internal.BaseAntiDDoSService;
import com.huawei.openstack4j.openstack.antiddos.options.AntiDDoSLogListOptions;
import com.huawei.openstack4j.openstack.antiddos.options.AntiDDoSStatusListOptions;
import java.util.Date;
import java.util.List;

public class AntiDDoSService
extends BaseAntiDDoSService
implements RestService {
    public AntiDDoSConfig listConfigs() {
        return this.get(AntiDDoSConfig.class, this.uri("/antiddos/query_config_list", new Object[0])).execute();
    }

    public Task create(AntiDDoS entity, String floatingIpId) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        Preconditions.checkArgument((entity.getEnableL7() != null ? 1 : 0) != 0, (Object)"enableL7 is required");
        Preconditions.checkArgument((entity.getTrafficPos() != null ? 1 : 0) != 0, (Object)"trafficPos is required");
        Preconditions.checkArgument((entity.getHttpRequestPos() != null ? 1 : 0) != 0, (Object)"httpRequestPos is required");
        Preconditions.checkArgument((entity.getCleaningAccessPos() != null ? 1 : 0) != 0, (Object)"cleaningAccessPos is required");
        Preconditions.checkArgument((entity.getAppType() != null ? 1 : 0) != 0, (Object)"appType is required");
        return this.post(Task.class, this.uri("/antiddos/%s", floatingIpId)).entity(entity).execute();
    }

    public Task delete(String floatingIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        return this.delete(Task.class, this.uri("/antiddos/%s", floatingIpId)).execute();
    }

    public AntiDDoS get(String floatingIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        return this.get(AntiDDoS.class, this.uri("/antiddos/%s", floatingIpId)).execute();
    }

    public Task update(AntiDDoS entity, String floatingIpId) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        Preconditions.checkArgument((entity.getEnableL7() != null ? 1 : 0) != 0, (Object)"enableL7 is required");
        Preconditions.checkArgument((entity.getTrafficPos() != null ? 1 : 0) != 0, (Object)"trafficPos is required");
        Preconditions.checkArgument((entity.getHttpRequestPos() != null ? 1 : 0) != 0, (Object)"httpRequestPos is required");
        Preconditions.checkArgument((entity.getCleaningAccessPos() != null ? 1 : 0) != 0, (Object)"cleaningAccessPos is required");
        Preconditions.checkArgument((entity.getAppType() != null ? 1 : 0) != 0, (Object)"appType is required");
        return this.put(Task.class, this.uri("/antiddos/%s", floatingIpId)).entity(entity).execute();
    }

    public Task getTask(String taskId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskId) ? 1 : 0) != 0, (Object)"taskId is required");
        return this.get(Task.class, this.uri("/query_task_status", new Object[0])).param("task_id", taskId).execute();
    }

    public AntiDDoSStatus listStatus() {
        return this.get(AntiDDoSStatus.class, this.uri("/antiddos", new Object[0])).execute();
    }

    public AntiDDoSStatus listStatus(AntiDDoSStatusListOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options is required");
        return this.get(AntiDDoSStatus.class, this.uri("/antiddos", new Object[0])).params(options.getOptions()).execute();
    }

    public AntiDDoSStatusDetail getStatus(String floatingIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        return this.get(AntiDDoSStatusDetail.class, this.uri("/antiddos/%s/status", floatingIpId)).execute();
    }

    public List<? extends AntiDDoSDailyData> dailyReport(String floatingIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        return this.get(AntiDDoSDailyData.AntiDDoSDailyDatas.class, this.uri("/antiddos/%s/daily", floatingIpId)).execute().getList();
    }

    public List<? extends AntiDDoSLog> listLogs(String floatingIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        return this.get(AntiDDoSLog.AntiDDoSLogs.class, this.uri("/antiddos/%s/logs", floatingIpId)).execute().getList();
    }

    public List<? extends AntiDDoSLog> listLogs(String floatingIpId, AntiDDoSLogListOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)floatingIpId) ? 1 : 0) != 0, (Object)"floatingIpId is required");
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options is required");
        return this.get(AntiDDoSLog.AntiDDoSLogs.class, this.uri("/antiddos/%s/logs", floatingIpId)).params(options.getOptions()).execute().getList();
    }

    public AntiDDoSWeeklyData weeklyReport() {
        return this.get(AntiDDoSWeeklyData.class, this.uri("/antiddos/weekly", new Object[0])).execute();
    }

    public AntiDDoSWeeklyData weeklyReport(Date periodStartDate) {
        Preconditions.checkArgument((periodStartDate != null ? 1 : 0) != 0, (Object)"periodStartDate is required");
        return this.get(AntiDDoSWeeklyData.class, this.uri("/antiddos/weekly", new Object[0])).param("period_start_date", periodStartDate.getTime()).execute();
    }
}

