/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.artifact.internal;

import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.model.artifact.ArtifactType;
import com.huawei.openstack4j.model.artifact.ArtifactUpdate;
import com.huawei.openstack4j.model.artifact.ToscaTemplatesArtifact;
import com.huawei.openstack4j.model.artifact.builder.ArtifactUpdateBuilder;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.common.payloads.FilePayload;
import com.huawei.openstack4j.openstack.artifact.domain.ArtifactUpdateModel;
import com.huawei.openstack4j.openstack.common.ListEntity;
import com.huawei.openstack4j.openstack.common.functions.EnforceVersionToURL;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BaseArtifactServiceImpl
extends BaseOpenStackService {
    private ArtifactType artifactType;

    protected BaseArtifactServiceImpl(ArtifactType artifactType) {
        super(ServiceType.ARTIFACT, EnforceVersionToURL.instance(""));
        this.artifactType = artifactType;
    }

    protected <T> T list(Class<T> clazz) {
        return this.get(clazz, this.uri("/artifacts/" + this.artifactType.value(), new Object[0])).execute();
    }

    protected <T> T get(String artifactId, Class<T> clazz) {
        return this.get(clazz, this.uri("/artifacts/" + this.artifactType.value() + "/%s", artifactId)).execute();
    }

    protected <T> T create(ToscaTemplatesArtifact toscaTemplatesArtifact, Class<T> clazz) {
        return this.post(clazz, this.uri("/artifacts/" + this.artifactType.value(), new Object[0])).entity(toscaTemplatesArtifact).execute();
    }

    protected <T> T upload(String artifactId, File file, Class<T> clazz, String blobName) {
        FilePayload payload = new FilePayload(file);
        BaseOpenStackService.Invocation<T> invocation = this.put(clazz, this.uri("/artifacts/" + this.artifactType.value() + "/%s/%s", artifactId, blobName));
        invocation.entity(payload);
        return invocation.execute();
    }

    protected InputStream download(String artifactId, String blobName) {
        BaseOpenStackService.Invocation<Void> invocation = this.get(Void.class, this.uri("/artifacts/" + this.artifactType.value() + "/%s/%s", artifactId, blobName));
        invocation.header("Accept", "application/octet-stream");
        HttpResponse response = invocation.executeWithResponse();
        if (response.getStatus() < 400) {
            return response.getInputStream();
        }
        return null;
    }

    protected ActionResponse delete(String artifactId) {
        return this.deleteWithResponse(this.uri("/artifacts/" + this.artifactType.value() + "/%s", artifactId)).execute();
    }

    protected <T> T update(String artifactId, List<ArtifactUpdate> artifactUpdates, Class<T> clazz) {
        BaseOpenStackService.Invocation<T> invocation = this.patch(clazz, this.uri("/artifacts/" + this.artifactType.value() + "/%s", artifactId));
        invocation.entity(new ListEntity<ArtifactUpdate>(artifactUpdates));
        invocation.contentType("application/json-patch+json");
        return invocation.execute();
    }

    protected <T> T update(String artifactId, String op, String path, String value, Class<T> clazz) {
        ArtifactUpdateBuilder updateBuilder = ArtifactUpdateModel.builder();
        updateBuilder.op(op);
        updateBuilder.path(path);
        updateBuilder.value(value);
        ArrayList artifactUpdates = new ArrayList();
        artifactUpdates.add(updateBuilder.build());
        BaseOpenStackService.Invocation<T> invocation = this.patch(clazz, this.uri("/artifacts/" + this.artifactType.value() + "/%s", artifactId));
        invocation.entity(new ListEntity(artifactUpdates));
        invocation.contentType("application/json-patch+json");
        return invocation.execute();
    }
}

