/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.barbican.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.huawei.openstack4j.api.barbican.ContainerService;
import com.huawei.openstack4j.model.barbican.Container;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.barbican.domain.BarbicanContainer;
import com.huawei.openstack4j.openstack.barbican.internal.BaseBarbicanServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class ContainerServiceImpl
extends BaseBarbicanServices
implements ContainerService {
    private static final String RESOURCE_PATH = "/containers";
    private static final String SPECIFIC_RESOURCE_PATH = "/containers/%s";

    @Override
    public List<? extends Container> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<BarbicanContainer.Containers> req = this.get(BarbicanContainer.Containers.class, this.uri(RESOURCE_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public List<? extends Container> list(String name) {
        return this.list((Map<String, String>)ImmutableMap.of((Object)"name", (Object)name));
    }

    @Override
    public Container get(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return this.get(BarbicanContainer.class, this.uri(SPECIFIC_RESOURCE_PATH, containerId)).execute();
    }

    @Override
    public ActionResponse delete(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return this.deleteWithResponse(this.uri(SPECIFIC_RESOURCE_PATH, containerId)).execute();
    }

    @Override
    public Container create(Container container) {
        Preconditions.checkNotNull((Object)container);
        return this.post(BarbicanContainer.class, this.uri(RESOURCE_PATH, new Object[0])).entity(container).execute();
    }
}

