/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.bms.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.bms.v1.domain.BareMetaServer;
import com.huawei.openstack4j.openstack.bms.v1.domain.ServerCreate;
import com.huawei.openstack4j.openstack.bms.v1.domain.ServerRename;
import com.huawei.openstack4j.openstack.bms.v1.domain.VolumeAttachment;
import com.huawei.openstack4j.openstack.bms.v1.internal.BaseBareMetaService;
import com.huawei.openstack4j.openstack.common.AsyncRespEntity;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;

public class ServerService
extends BaseBareMetaService {
    public AsyncRespEntity create(ServerCreate creation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getImageRef()) ? 1 : 0) != 0, (Object)"parameter `imageRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getVpcId()) ? 1 : 0) != 0, (Object)"parameter `vpcId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getAvailabilityZone()) ? 1 : 0) != 0, (Object)"parameter `availability_zone` should not be empty");
        Preconditions.checkArgument((creation.getNetworks() != null && creation.getNetworks().size() > 0 ? 1 : 0) != 0, (Object)"parameter `networks` should not be empty");
        Preconditions.checkArgument((creation.getMetadata() != null ? 1 : 0) != 0, (Object)"parameter `metadata` should not be empty");
        Preconditions.checkArgument((creation.getExtendParam() != null ? 1 : 0) != 0, (Object)"parameter `extendparam` should not be empty");
        return this.post(AsyncRespEntity.class, "/baremetalservers").entity(creation).execute();
    }

    public BareMetaServer get(String serverId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverId) ? 1 : 0) != 0, (Object)"parameter `serverId` should not be empty");
        return this.get(BareMetaServer.class, this.uri("/baremetalservers/", new Object[0]) + serverId).execute();
    }

    public BareMetaServer rename(String serverId, String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverId) ? 1 : 0) != 0, (Object)"parameter `serverId` should not be empty");
        return this.put(BareMetaServer.class, this.uri("/baremetalservers/", new Object[0]) + serverId).entity(ServerRename.builder().name(name).build()).execute();
    }

    public ActionResponse attachVolume(String serverId, VolumeAttachment volume) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverId) ? 1 : 0) != 0, (Object)"parameter `serverId` should not be empty");
        Preconditions.checkArgument((volume != null ? 1 : 0) != 0, (Object)"parameter `volume` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/baremetalservers/%s/attachvolume", serverId)).entity(volume).executeWithResponse());
    }

    public ActionResponse detachVolume(String serverId, String attachmentId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverId) ? 1 : 0) != 0, (Object)"parameter `serverId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)attachmentId) ? 1 : 0) != 0, (Object)"parameter `attachmentId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/baremetalservers/%s/detachvolume/%s", serverId, attachmentId)).executeWithResponse());
    }
}

