/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cdn.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.cdn.v1.domain.CacheRule;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="cache_config")
public class CacheConfig
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="ignore_cache_control")
    private Boolean ignoreCacheControl;
    @JsonProperty(value="ignore_url_parameter")
    private Boolean ignoreUrlParameter;
    @JsonProperty(value="rules")
    private List<CacheRule> rules;

    public static CacheConfigBuilder builder() {
        return new CacheConfigBuilder();
    }

    public CacheConfigBuilder toBuilder() {
        return new CacheConfigBuilder().ignoreCacheControl(this.ignoreCacheControl).ignoreUrlParameter(this.ignoreUrlParameter).rules(this.rules);
    }

    public Boolean getIgnoreCacheControl() {
        return this.ignoreCacheControl;
    }

    public Boolean getIgnoreUrlParameter() {
        return this.ignoreUrlParameter;
    }

    public List<CacheRule> getRules() {
        return this.rules;
    }

    public String toString() {
        return "CacheConfig(ignoreCacheControl=" + this.getIgnoreCacheControl() + ", ignoreUrlParameter=" + this.getIgnoreUrlParameter() + ", rules=" + this.getRules() + ")";
    }

    public CacheConfig() {
    }

    @ConstructorProperties(value={"ignoreCacheControl", "ignoreUrlParameter", "rules"})
    public CacheConfig(Boolean ignoreCacheControl, Boolean ignoreUrlParameter, List<CacheRule> rules) {
        this.ignoreCacheControl = ignoreCacheControl;
        this.ignoreUrlParameter = ignoreUrlParameter;
        this.rules = rules;
    }

    public static class CacheConfigBuilder {
        private Boolean ignoreCacheControl;
        private Boolean ignoreUrlParameter;
        private List<CacheRule> rules;

        CacheConfigBuilder() {
        }

        public CacheConfigBuilder ignoreCacheControl(Boolean ignoreCacheControl) {
            this.ignoreCacheControl = ignoreCacheControl;
            return this;
        }

        public CacheConfigBuilder ignoreUrlParameter(Boolean ignoreUrlParameter) {
            this.ignoreUrlParameter = ignoreUrlParameter;
            return this;
        }

        public CacheConfigBuilder rules(List<CacheRule> rules) {
            this.rules = rules;
            return this;
        }

        public CacheConfig build() {
            return new CacheConfig(this.ignoreCacheControl, this.ignoreUrlParameter, this.rules);
        }

        public String toString() {
            return "CacheConfig.CacheConfigBuilder(ignoreCacheControl=" + this.ignoreCacheControl + ", ignoreUrlParameter=" + this.ignoreUrlParameter + ", rules=" + this.rules + ")";
        }
    }
}

